/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.transformation.provider;

import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.transformation.provider.ClustalOmegaAlignmentTransformationConfigurationChangeType;
import org.sing_group.seda.clustalomega.transformation.sequencesgroup.ClustalOmegaAlignmentSequencesGroupTransformation;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class ClustalOmegaAlignmentTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private ClustalOmegaBinariesExecutor binariesExecutor;
    @XmlElement
    private int numThreads;
    @XmlElement
    private String additionalParameters;

    @Override
    public Validation validate() {
        if (this.binariesExecutor == null) {
            return new DefaultValidation("The Clustal Omega binaries executor has not been set.");
        }
        try {
            this.binariesExecutor.checkBinary();
            return new DefaultValidation(new String[0]);
        }
        catch (BinaryCheckException e) {
            return new DefaultValidation("The Clustal Omega binaries executor can't be used.");
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return new ComposedSequencesGroupDatasetTransformation(this.getClustalOmegaTransformation(factory));
    }

    private ClustalOmegaAlignmentSequencesGroupTransformation getClustalOmegaTransformation(DatatypeFactory factory) {
        return new ClustalOmegaAlignmentSequencesGroupTransformation(factory, this.binariesExecutor, this.numThreads, this.additionalParameters);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        if (this.numThreads != numThreads) {
            this.numThreads = numThreads;
            this.fireTransformationsConfigurationModelEvent(ClustalOmegaAlignmentTransformationConfigurationChangeType.NUM_THREADS_CHANGED, this.numThreads);
        }
    }

    public void setAdditionalParameters(String additionalParameters) {
        if (!(additionalParameters == null || this.additionalParameters != null && this.additionalParameters.equals(additionalParameters))) {
            this.additionalParameters = additionalParameters;
            this.fireTransformationsConfigurationModelEvent(ClustalOmegaAlignmentTransformationConfigurationChangeType.ADDITIONAL_PARAMETERS_CHANGED, this.additionalParameters);
        }
    }

    public String getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setBinariesExecutor(Optional<ClustalOmegaBinariesExecutor> clustalOmegaBinariesExecutor) {
        this.binariesExecutor = clustalOmegaBinariesExecutor.isPresent() ? clustalOmegaBinariesExecutor.get() : null;
        this.fireTransformationsConfigurationModelEvent(ClustalOmegaAlignmentTransformationConfigurationChangeType.CLUSTAL_OMEGA_EXECUTOR_CHANGED, this.binariesExecutor);
    }

    public ClustalOmegaBinariesExecutor getBinariesExecutor() {
        return this.binariesExecutor;
    }
}

