/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.yacli.command.option;

import es.uvigo.ei.sing.yacli.command.option.OptionCategory;
import es.uvigo.ei.sing.yacli.command.option.OptionConverter;
import es.uvigo.ei.sing.yacli.command.parameter.MultipleParameterValue;
import es.uvigo.ei.sing.yacli.command.parameter.ParameterValue;
import es.uvigo.ei.sing.yacli.command.parameter.SingleParameterValue;
import java.util.Arrays;
import java.util.List;

public class Option<T> {
    private final String paramName;
    private final String shortName;
    private final String description;
    private final boolean optional;
    private final boolean requiresValue;
    private final boolean isMultiple;
    private final OptionConverter<T> converter;
    private final List<OptionCategory> categories;

    public Option(List<OptionCategory> categories, String paramName, String shortName, String description, boolean optional, boolean requiresValue, boolean isMultiple, OptionConverter<T> converter) {
        this.categories = categories;
        this.paramName = paramName;
        this.shortName = shortName;
        this.description = description;
        this.optional = optional;
        this.requiresValue = requiresValue;
        this.isMultiple = isMultiple;
        this.converter = converter;
    }

    public Option(List<OptionCategory> categories, String paramName, String shortName, String description, boolean optional, boolean requiresValue, OptionConverter<T> converter) {
        this(categories, paramName, shortName, description, optional, requiresValue, false, converter);
    }

    public Option(String paramName, String shortName, String description, boolean optional, boolean requiresValue, boolean isMultiple, OptionConverter<T> converter) {
        this(Arrays.asList(OptionCategory.DEFAULT_CATEGORY), paramName, shortName, description, optional, requiresValue, isMultiple, converter);
    }

    public Option(String paramName, String shortName, String description, boolean optional, boolean requiresValue, OptionConverter<T> converter) {
        this(Arrays.asList(OptionCategory.DEFAULT_CATEGORY), paramName, shortName, description, optional, requiresValue, converter);
    }

    public List<OptionCategory> getCategories() {
        return this.categories;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public OptionConverter<T> getConverter() {
        return this.converter;
    }

    public boolean hasName(String name) {
        return this.paramName.equalsIgnoreCase(name) || this.shortName.equalsIgnoreCase(name);
    }

    public boolean canConvert(ParameterValue<?> value) {
        if (value instanceof SingleParameterValue) {
            return this.getConverter().canConvert((SingleParameterValue)value);
        }
        if (value instanceof MultipleParameterValue) {
            return this.getConverter().canConvert((MultipleParameterValue)value);
        }
        return false;
    }

    public String toString() {
        return this.getShortName();
    }
}

