/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.ei.sing.yacli;

import es.uvigo.ei.sing.yacli.CLIApplicationCommandException;
import es.uvigo.ei.sing.yacli.CLIApplicationException;
import es.uvigo.ei.sing.yacli.ParsingException;
import es.uvigo.ei.sing.yacli.command.Command;
import es.uvigo.ei.sing.yacli.command.CommandPrinter;
import es.uvigo.ei.sing.yacli.command.CommandPrinterConfiguration;
import es.uvigo.ei.sing.yacli.command.option.DefaultValuedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.parameter.DefaultParameters;
import es.uvigo.ei.sing.yacli.command.parameter.MultipleParameterValue;
import es.uvigo.ei.sing.yacli.command.parameter.ParameterValue;
import es.uvigo.ei.sing.yacli.command.parameter.SingleParameterValue;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class CLIApplication {
    private final Map<String, Command> commandsByName;
    private boolean showApplicationCommandInHelp;
    private boolean ignoreUnrecognizedOptions;
    private CommandPrinterConfiguration commandPrinterConfiguration;

    protected abstract List<Command> buildCommands();

    protected abstract String getApplicationName();

    protected abstract String getApplicationVersion();

    protected abstract String getApplicationCommand();

    protected CommandPrinterConfiguration getCommandPrinterConfiguration() {
        return new CommandPrinterConfiguration();
    }

    public CLIApplication() {
        this(true, true);
    }

    public CLIApplication(boolean showApplicationCommandInHelp) {
        this(showApplicationCommandInHelp, true);
    }

    protected CLIApplication(boolean showApplicationCommandInHelp, boolean preloadCommands) {
        this(showApplicationCommandInHelp, preloadCommands, false);
    }

    protected CLIApplication(boolean showApplicationCommandInHelp, boolean preloadCommands, boolean ignoreUnrecognizedOptions) {
        this.showApplicationCommandInHelp = showApplicationCommandInHelp;
        this.commandsByName = new LinkedHashMap<String, Command>();
        this.ignoreUnrecognizedOptions = ignoreUnrecognizedOptions;
        if (preloadCommands) {
            this.loadCommands();
        }
        this.commandPrinterConfiguration = this.getCommandPrinterConfiguration();
    }

    protected void loadCommands() {
        for (Command c : this.buildCommands()) {
            this.commandsByName.put(c.getName().toUpperCase(), c);
        }
    }

    protected List<Command> listCommands() {
        return new ArrayList<Command>(this.commandsByName.values());
    }

    public boolean isShowApplicationCommandInHelp() {
        return this.showApplicationCommandInHelp;
    }

    public void setShowApplicationCommandInHelp(boolean showApplicationCommandInHelp) {
        this.showApplicationCommandInHelp = showApplicationCommandInHelp;
    }

    protected String getDescription() {
        return "";
    }

    public void run(String[] args) throws CLIApplicationException {
        PrintStream out = System.err;
        if (args.length == 0) {
            this.printHelp(out);
        } else if (CLIApplication.isVersionArgument(args[0])) {
            out.println(this.getApplicationVersion());
        } else if (CLIApplication.isHelpArgument(args[0])) {
            if (args.length >= 2) {
                Command command = this.commandsByName.get(args[1].toUpperCase());
                if (command != null) {
                    this.printWelcome(out);
                    this.printCommandHelp(command, out, this.commandPrinterConfiguration);
                } else {
                    out.println("Command " + args[1] + " not found");
                    this.printHelp(out);
                }
            } else {
                this.printHelp(out);
            }
        } else {
            Command command = this.commandsByName.get(args[0].toUpperCase());
            if (command != null) {
                String[] noFirst = new String[args.length - 1];
                System.arraycopy(args, 1, noFirst, 0, noFirst.length);
                try {
                    Map<Option<?>, ParameterValue<?>> values = this.parseCommand(command, noFirst);
                    DefaultParameters parameters = new DefaultParameters(values);
                    command.execute(parameters);
                }
                catch (Exception e) {
                    this.handleCommandException(new CLIApplicationCommandException(command, (Throwable)e), out);
                }
            } else {
                this.handleException(new CLIApplicationException(new IllegalArgumentException("Command " + args[0] + " not found")), out);
            }
        }
    }

    protected void handleCommandException(CLIApplicationCommandException exception, PrintStream out) {
        if (exception.getCause() instanceof ParsingException) {
            out.println("Error parsing command: " + exception.getCause().getMessage());
            this.printCommandHelp(exception.getCommand(), out, this.commandPrinterConfiguration);
            throw exception;
        }
        out.println("Error during execution: " + exception.getMessage());
        throw exception;
    }

    protected void handleException(CLIApplicationException exception, PrintStream out) {
        out.println(exception.getMessage());
        this.printHelp(out);
        throw exception;
    }

    protected static boolean isVersionArgument(String arg) {
        return arg.equalsIgnoreCase("-v") || arg.equalsIgnoreCase("--version");
    }

    protected static boolean isHelpArgument(String arg) {
        return arg.equalsIgnoreCase("help") || arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("--help");
    }

    private Map<Option<?>, ParameterValue<?>> parseCommand(Command command, String[] arguments) throws ParsingException {
        HashMap<Option, Object> values = new HashMap<Option, Object>();
        command.getOptions();
        Option currentOption = null;
        Option IGNORE_OPTION = new Option("--ignore--", "--ignore--", "--ignore--", false, false, null);
        for (String token : arguments) {
            if (token.startsWith("-")) {
                if (currentOption != null && !values.containsKey(currentOption) && currentOption.requiresValue()) {
                    throw new IllegalArgumentException(String.format("option %s requires a value", currentOption.getParamName()));
                }
                if (currentOption != null && !values.containsKey(currentOption) && !currentOption.requiresValue()) {
                    values.put(currentOption, null);
                }
                String optionName = null;
                optionName = token.charAt(1) == '-' ? token.substring(2) : token.substring(1);
                Option option = command.getOption(optionName);
                if (option == null) {
                    if (this.ignoreUnrecognizedOptions) {
                        currentOption = IGNORE_OPTION;
                        continue;
                    }
                    throw new ParsingException(String.format("option %s not found", optionName));
                }
                currentOption = option;
                continue;
            }
            if (currentOption == null) {
                throw new ParsingException("unable to parse. You should specify an option before a value");
            }
            if (this.ignoreUnrecognizedOptions && currentOption == IGNORE_OPTION) continue;
            if (values.containsKey(currentOption)) {
                if (currentOption.isMultiple()) {
                    List valuesList = (List)values.get(currentOption);
                    valuesList.add(token);
                    continue;
                }
                throw new ParsingException("option " + currentOption.getParamName() + " was already specified");
            }
            if (currentOption.isMultiple()) {
                ArrayList<String> toAddValues = new ArrayList<String>();
                toAddValues.add(token);
                values.put(currentOption, toAddValues);
                continue;
            }
            values.put(currentOption, token);
        }
        if (currentOption != null && !values.containsKey(currentOption) && currentOption.requiresValue()) {
            throw new ParsingException("option " + currentOption.getParamName() + " requires a value");
        }
        if (currentOption != null && !values.containsKey(currentOption) && !currentOption.requiresValue()) {
            values.put(currentOption, null);
        }
        for (Option option : command.getOptions()) {
            if (!(option.isOptional() || values.containsKey(option) || option instanceof DefaultValuedOption)) {
                throw new ParsingException("option " + option.getParamName() + " is mandatory");
            }
            if (values.containsKey(option) || !(option instanceof DefaultValuedOption)) continue;
            values.put(option, ((DefaultValuedOption)option).getDefaultValue());
        }
        HashMap paramValues = new HashMap();
        for (Map.Entry parameterValue : values.entrySet()) {
            Option key;
            Object value = parameterValue.getValue();
            paramValues.put(key, (key = (Option)parameterValue.getKey()).isMultiple() ? new MultipleParameterValue((List)value) : new SingleParameterValue((String)value));
        }
        return paramValues;
    }

    protected void printCommandHelp(Command command, PrintStream out, CommandPrinterConfiguration configuration) {
        out.println("Command " + command.getName());
        this.printCommandUsage(command, out);
        CommandPrinter.printCommandOptionsExtended(command, out, configuration);
    }

    protected void printCommandUsage(Command command, PrintStream out) {
        this.printCommandOptions(command, out);
        out.println();
    }

    protected void printCommandOptions(Command command, PrintStream out) {
        StringBuilder sb = new StringBuilder("usage: ");
        sb.append(this.getApplicationCommand());
        sb.append(" ");
        sb.append(command.getName());
        for (Option<?> option : command.getOptions()) {
            if (option.isOptional()) {
                sb.append(" [");
            } else {
                sb.append(" ");
            }
            sb.append("-" + option.getShortName());
            if (option.requiresValue()) {
                sb.append(" <" + option.getParamName() + ">");
            }
            if (!option.isOptional()) continue;
            sb.append("]");
        }
        if (this.commandPrinterConfiguration.getBreakLines() == 0) {
            out.print(sb.toString());
        } else {
            out.print(CLIApplication.breakString(sb.toString(), this.commandPrinterConfiguration.getBreakLines(), "\t"));
        }
    }

    private static String breakString(String text, int breakLines, String indent) {
        ArrayList<String> toret = new ArrayList<String>();
        StringBuilder currentString = new StringBuilder();
        StringBuilder currentOption = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char current = text.charAt(i);
            if (current != ' ') {
                currentOption.append(current);
                continue;
            }
            if (i + 1 < text.length() && text.charAt(i + 1) == '<') {
                currentOption.append(current);
                continue;
            }
            if (currentString.length() + currentOption.length() + 1 < breakLines) {
                currentString.append((CharSequence)currentOption).append(" ");
                currentOption = new StringBuilder();
                continue;
            }
            toret.add(currentString.toString());
            currentString = new StringBuilder(indent);
            currentString.append((CharSequence)currentOption).append(" ");
            currentOption = new StringBuilder();
        }
        if (currentString.length() + currentOption.length() + 1 < breakLines) {
            currentString.append((CharSequence)currentOption).append(" ");
        } else {
            toret.add(currentString.toString());
            currentString = new StringBuilder(indent);
            currentString.append((CharSequence)currentOption).append(" ");
        }
        if (currentString.length() > 0) {
            toret.add(currentString.toString());
        }
        return toret.stream().collect(Collectors.joining("\n"));
    }

    protected void printHelp(PrintStream out) {
        this.printWelcome(out);
        out.println("usage: " + this.getApplicationCommand() + " <command> [options]");
        this.printCommandsInHelp(out, this.listCommands());
        if (this.isShowApplicationCommandInHelp()) {
            out.println("Write '" + this.getApplicationCommand() + " help <command>' to see command-specific help");
        } else {
            out.println("Write 'help <command>' to see command-specific help");
        }
    }

    protected void printCommandsInHelp(PrintStream out, List<Command> commands) {
        out.println("where <command> is one of:");
        for (Command command : this.listCommands()) {
            this.printCommandInHelp(out, command);
        }
    }

    protected void printCommandInHelp(PrintStream out, Command command) {
        out.println("\t" + command.getName() + "\n\t\t" + command.getDescription());
    }

    protected void printWelcome(PrintStream out) {
        out.println("Welcome to " + this.getApplicationName());
        out.println(this.getDescription());
    }
}

