/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.tool;

import java.io.IOException;
import uk.ac.ebi.uniprot.parser.UniprotLineParser;
import uk.ac.ebi.uniprot.parser.impl.DefaultUniprotLineParserFactory;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.tool.EntryBufferedReader;

public class SimpleFFParser {
    private String startParingString;

    public static void main(String[] args) throws IOException {
        SimpleFFParser ffParser = new SimpleFFParser();
        if (args.length == 2) {
            ffParser.setStartParingString(args[1]);
        }
        ffParser.parse(args[0]);
    }

    public String getStartParingString() {
        return this.startParingString;
    }

    public void setStartParingString(String startParingString) {
        this.startParingString = startParingString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String in) throws IOException {
        boolean found = true;
        if (this.startParingString != null) {
            found = false;
        }
        EntryBufferedReader reader = new EntryBufferedReader(in);
        String entry = reader.next();
        if (this.startParingString != null) {
            found = entry.startsWith(this.startParingString);
        }
        boolean foundNext = false;
        int count = 0;
        long time = 0L;
        try {
            while (entry != null) {
                if (found && !foundNext) {
                    foundNext = true;
                } else if (found && foundNext) {
                    ++count;
                    long start = System.currentTimeMillis();
                    EntryObject entryObject = this.parseEntry(entry);
                    System.out.println(entryObject.id.entryName);
                    time += System.currentTimeMillis() - start;
                }
                entry = reader.next();
                if (found || this.startParingString == null) continue;
                found = entry.startsWith(this.startParingString);
            }
        }
        catch (Throwable throwable) {
            System.out.println(String.format("parsing %s entries total time used %s", count, time));
            throw throwable;
        }
        System.out.println(String.format("parsing %s entries total time used %s", count, time));
    }

    private EntryObject parseEntry(String entry) {
        DefaultUniprotLineParserFactory parserFactory = new DefaultUniprotLineParserFactory();
        UniprotLineParser<EntryObject> entryParser = parserFactory.createEntryParser();
        EntryObject parse = entryParser.parse(entry);
        return parse;
    }
}

