/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.tool;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.tool.EntryBufferedReader;
import uk.ac.ebi.uniprot.parser.tool.EntryObjectListener;
import uk.ac.ebi.uniprot.parser.tool.LimitedQueue;
import uk.ac.ebi.uniprot.parser.tool.ListenerJob;
import uk.ac.ebi.uniprot.parser.tool.ParsingJob;

public class MTFFParser {
    private final EntryBufferedReader reader;
    private final ListeningExecutorService parsingExecutor;
    private final ExecutorService listenerExecutor;
    private List<EntryObjectListener> listenerList = new ArrayList<EntryObjectListener>();

    public MTFFParser(EntryBufferedReader reader) {
        this.reader = reader;
        LimitedQueue<Runnable> internalQueue = new LimitedQueue<Runnable>(1000);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, internalQueue);
        this.parsingExecutor = MoreExecutors.listeningDecorator((ExecutorService)threadPoolExecutor);
        this.listenerExecutor = Executors.newFixedThreadPool(5);
    }

    public void addListener(EntryObjectListener listener) {
        this.listenerList.add(listener);
    }

    public void start() throws IOException {
        String next = this.reader.next();
        while (next != null) {
            ParsingJob parsingJob = new ParsingJob(next);
            ListenableFuture submit = this.parsingExecutor.submit((Callable)parsingJob);
            Futures.addCallback((ListenableFuture)submit, (FutureCallback)new FutureCallback<EntryObject>(){

                public void onSuccess(EntryObject entryObject) {
                    for (EntryObjectListener listener : MTFFParser.this.listenerList) {
                        ListenerJob listenerJob = new ListenerJob(listener, entryObject);
                        MTFFParser.this.listenerExecutor.submit(listenerJob);
                    }
                }

                public void onFailure(Throwable throwable) {
                }
            });
            next = this.reader.next();
        }
    }

    public void shutdown() throws InterruptedException {
        this.parsingExecutor.shutdown();
        this.parsingExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.listenerExecutor.shutdown();
        this.listenerExecutor.awaitTermination(1L, TimeUnit.DAYS);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        EntryBufferedReader reader1 = new EntryBufferedReader(args[0]);
        MTFFParser mtffParser = new MTFFParser(reader1);
        mtffParser.start();
        mtffParser.shutdown();
    }
}

