/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.de;

import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.DeLineParser;
import uk.ac.ebi.uniprot.parser.antlr.DeLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.EvidenceInfo;
import uk.ac.ebi.uniprot.parser.impl.de.DeLineObject;

public class DeLineModelListener
extends DeLineParserBaseListener
implements ParseTreeObjectExtractor<DeLineObject> {
    private DeLineObject object;
    private DeLineObject.NameBlock block;

    @Override
    public DeLineObject getObject() {
        return this.object;
    }

    @Override
    public void enterDe_de(DeLineParser.De_deContext ctx) {
        this.object = new DeLineObject();
    }

    @Override
    public void exitRec_name(DeLineParser.Rec_nameContext ctx) {
        this.object.recName = new DeLineObject.Name();
        this.object.recName.fullName = ctx.full_name().name_value().getText();
        this.object.recName.fullName = this.object.getEvidenceInfo().retrieveEvidenceString(this.object.recName.fullName);
        List<DeLineParser.Short_nameContext> shortNameContexts = ctx.short_name();
        for (DeLineParser.Short_nameContext shortNameContext : shortNameContexts) {
            String name = shortNameContext.name_value().getText();
            this.object.recName.shortNames.add(this.object.getEvidenceInfo().retrieveEvidenceString(name));
        }
        List<DeLineParser.EcContext> ec = ctx.ec();
        for (DeLineParser.EcContext ecContext : ec) {
            this.processECs(ecContext, this.object.recName);
        }
    }

    private void processECs(DeLineParser.EcContext context, DeLineObject.Name nameBelong) {
        String ecValue = context.EC_NAME_VALUE().getText();
        nameBelong.ecs.add(ecValue);
        DeLineParser.EvidenceContext evidence = context.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            DeLineObject.ECEvidence ecEvidence = new DeLineObject.ECEvidence();
            ecEvidence.ecValue = ecValue;
            ecEvidence.nameECBelong = nameBelong;
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), ecEvidence, terminalNodes);
        }
    }

    @Override
    public void exitAlt_biotech(DeLineParser.Alt_biotechContext ctx) {
        this.object.altBiotech = ctx.name_value().getText();
        this.object.altBiotech = this.object.getEvidenceInfo().retrieveEvidenceString(this.object.altBiotech);
    }

    @Override
    public void exitAlt_inn(DeLineParser.Alt_innContext ctx) {
        String text = ctx.name_value().getText();
        this.object.altINN.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
    }

    @Override
    public void exitAlt_allergen(DeLineParser.Alt_allergenContext ctx) {
        this.object.altAllergen = ctx.name_value().getText();
        this.object.altAllergen = this.object.getEvidenceInfo().retrieveEvidenceString(this.object.altAllergen);
    }

    @Override
    public void exitAlt_cdantigen(DeLineParser.Alt_cdantigenContext ctx) {
        String text = ctx.name_value().getText();
        this.object.altCDantigen.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
    }

    @Override
    public void exitSub_alt_biotech(DeLineParser.Sub_alt_biotechContext ctx) {
        this.block.altBiotech = ctx.name_value().getText();
        this.block.altBiotech = this.object.getEvidenceInfo().retrieveEvidenceString(this.block.altBiotech);
    }

    @Override
    public void exitSub_alt_inn(DeLineParser.Sub_alt_innContext ctx) {
        String text = ctx.name_value().getText();
        this.block.altINN.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
    }

    @Override
    public void exitSub_alt_allergen(DeLineParser.Sub_alt_allergenContext ctx) {
        this.block.altAllergen = ctx.name_value().getText();
        this.block.altAllergen = this.object.getEvidenceInfo().retrieveEvidenceString(this.block.altAllergen);
    }

    @Override
    public void exitSub_alt_cdantigen(DeLineParser.Sub_alt_cdantigenContext ctx) {
        String text = ctx.name_value().getText();
        this.block.altCDantigen.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
    }

    @Override
    public void exitSub_rec_name(DeLineParser.Sub_rec_nameContext ctx) {
        this.block.recName = new DeLineObject.Name();
        this.block.recName.fullName = ctx.full_name().name_value().getText();
        this.block.recName.fullName = this.object.getEvidenceInfo().retrieveEvidenceString(this.block.recName.fullName);
        List<DeLineParser.Short_nameContext> shortNameContexts = ctx.short_name();
        for (DeLineParser.Short_nameContext shortNameContext : shortNameContexts) {
            String text = shortNameContext.name_value().getText();
            this.block.recName.shortNames.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
        }
        List<DeLineParser.EcContext> ec = ctx.ec();
        for (DeLineParser.EcContext ecContext : ec) {
            this.processECs(ecContext, this.block.recName);
        }
    }

    @Override
    public void exitSub_alt_name(DeLineParser.Sub_alt_nameContext ctx) {
        DeLineObject.Name name = new DeLineObject.Name();
        DeLineParser.Sub_alt_name_1Context altName1Context = ctx.sub_alt_name_1();
        DeLineParser.Sub_alt_name_2Context altName2Context = ctx.sub_alt_name_2();
        DeLineParser.Sub_alt_name_3Context altName3Context = ctx.sub_alt_name_3();
        if (altName1Context != null) {
            DeLineParser.Full_nameContext fullNameContext = altName1Context.full_name();
            if (fullNameContext != null) {
                name.fullName = fullNameContext.name_value().getText();
                name.fullName = this.object.getEvidenceInfo().retrieveEvidenceString(name.fullName);
            }
            List<DeLineParser.Short_nameContext> shortNameContexts = altName1Context.short_name();
            for (DeLineParser.Short_nameContext short_nameContext : shortNameContexts) {
                String text = short_nameContext.name_value().getText();
                name.shortNames.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
            }
            List<DeLineParser.EcContext> list = altName1Context.ec();
            for (DeLineParser.EcContext ecContext : list) {
                this.processECs(ecContext, name);
            }
        } else if (altName2Context != null) {
            List<DeLineParser.Short_nameContext> shortNameContexts = altName2Context.short_name();
            for (DeLineParser.Short_nameContext short_nameContext : shortNameContexts) {
                String string = short_nameContext.name_value().getText();
                name.shortNames.add(this.object.getEvidenceInfo().retrieveEvidenceString(string));
            }
            List<DeLineParser.EcContext> ec = altName2Context.ec();
            for (DeLineParser.EcContext ecContext : ec) {
                this.processECs(ecContext, name);
            }
        } else if (altName3Context != null) {
            List<DeLineParser.EcContext> ec = altName3Context.ec();
            for (DeLineParser.EcContext ecContext : ec) {
                this.processECs(ecContext, name);
            }
        }
        this.block.altName.add(name);
    }

    @Override
    public void exitAlt_name(DeLineParser.Alt_nameContext ctx) {
        DeLineObject.Name name = new DeLineObject.Name();
        DeLineParser.Alt_name_1Context altName1Context = ctx.alt_name_1();
        DeLineParser.Alt_name_2Context altName2Context = ctx.alt_name_2();
        DeLineParser.Alt_name_3Context altName3Context = ctx.alt_name_3();
        if (altName1Context != null) {
            if (altName1Context.full_name() != null) {
                name.fullName = altName1Context.full_name().name_value().getText();
                name.fullName = this.object.getEvidenceInfo().retrieveEvidenceString(name.fullName);
            }
            List<DeLineParser.Short_nameContext> shortNameContexts = altName1Context.short_name();
            for (DeLineParser.Short_nameContext short_nameContext : shortNameContexts) {
                String text = short_nameContext.name_value().getText();
                name.shortNames.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
            }
            List<DeLineParser.EcContext> ec = altName1Context.ec();
            for (DeLineParser.EcContext ecContext : ec) {
                this.processECs(ecContext, name);
            }
        } else if (altName2Context != null) {
            List<DeLineParser.Short_nameContext> shortNameContexts = altName2Context.short_name();
            for (DeLineParser.Short_nameContext short_nameContext : shortNameContexts) {
                String text = short_nameContext.name_value().getText();
                name.shortNames.add(this.object.getEvidenceInfo().retrieveEvidenceString(text));
            }
            List<DeLineParser.EcContext> ec = altName2Context.ec();
            Iterator iterator = ec.iterator();
            while (iterator.hasNext()) {
                DeLineParser.EcContext ecContext = (DeLineParser.EcContext)((Object)iterator.next());
                this.processECs(ecContext, name);
            }
        } else if (altName3Context != null) {
            List<DeLineParser.EcContext> ec = altName3Context.ec();
            for (DeLineParser.EcContext ecContext : ec) {
                this.processECs(ecContext, name);
            }
        }
        this.object.altName.add(name);
    }

    @Override
    public void exitSub_name(DeLineParser.Sub_nameContext ctx) {
        this.processExitSubname(ctx.full_name().name_value().getText(), ctx.ec(), this.object.subName);
    }

    private void processExitSubname(String nameString, List<DeLineParser.EcContext> ec, List<DeLineObject.Name> container) {
        DeLineObject.Name name = new DeLineObject.Name();
        name.fullName = this.object.getEvidenceInfo().retrieveEvidenceString(nameString);
        for (DeLineParser.EcContext ecContext : ec) {
            this.processECs(ecContext, name);
        }
        container.add(name);
    }

    @Override
    public void exitSub_sub_name(DeLineParser.Sub_sub_nameContext ctx) {
        this.processExitSubname(ctx.full_name().name_value().getText(), ctx.ec(), this.block.subName);
    }

    @Override
    public void enterIncluded_de(DeLineParser.Included_deContext ctx) {
        this.block = new DeLineObject.NameBlock();
    }

    @Override
    public void exitIncluded_de(DeLineParser.Included_deContext ctx) {
        this.object.includedNames.add(this.block);
        this.block = null;
    }

    @Override
    public void enterContained_de(DeLineParser.Contained_deContext ctx) {
        this.block = new DeLineObject.NameBlock();
    }

    @Override
    public void exitContained_de(DeLineParser.Contained_deContext ctx) {
        this.object.containedNames.add(this.block);
        this.block = null;
    }

    @Override
    public void exitFlag_value(DeLineParser.Flag_valueContext ctx) {
        DeLineObject.FlagType flag = null;
        if (ctx.FRAGMENT() != null) {
            flag = DeLineObject.FlagType.FRAGMENT;
        } else if (ctx.PRECURSOR() != null) {
            flag = DeLineObject.FlagType.PRECURSOR;
        } else if (ctx.FRAGMENTS() != null) {
            flag = DeLineObject.FlagType.FRAGMENTS;
        }
        this.object.flags.add(flag);
        DeLineParser.EvidenceContext evidence = ctx.evidence();
        if (evidence != null) {
            List<TerminalNode> terminalNodes = evidence.EV_TAG();
            EvidenceInfo.processEvidence(this.object.getEvidenceInfo(), (Object)flag, terminalNodes);
        }
    }
}

