/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.gocache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import uk.ac.ebi.kraken.interfaces.factories.GoFactory;
import uk.ac.ebi.kraken.interfaces.go.GoId;
import uk.ac.ebi.kraken.model.factories.DefaultGoFactoryImpl;

public class GoRelationFileReader {
    private static final String COMMENT_PREFIX = "!";
    private static final String SEPARATOR = "\t";
    private static final String PART_OF = "part_of";
    private static final String IS_A = "is_a";
    private Map<GoId, List<GoId>> isParentMap = new HashMap<GoId, List<GoId>>();
    private Map<GoId, List<GoId>> isPartParentMap = new HashMap<GoId, List<GoId>>();
    private Map<GoId, List<GoId>> isChildMap = new HashMap<GoId, List<GoId>>();
    private Map<GoId, List<GoId>> isPartChildMap = new HashMap<GoId, List<GoId>>();
    private final String filename;
    private final GoFactory factory = DefaultGoFactoryImpl.getInstance();

    public GoRelationFileReader(String filename) {
        this.filename = filename;
    }

    public Map<GoId, List<GoId>> getIsAParentMap() {
        return this.isParentMap;
    }

    public Map<GoId, List<GoId>> getIsPartParentMap() {
        return this.isPartParentMap;
    }

    public Map<GoId, List<GoId>> getIsAChildMap() {
        return this.isChildMap;
    }

    public Map<GoId, List<GoId>> getIsPartChildMap() {
        return this.isPartChildMap;
    }

    public void read() {
        try (Stream<String> stream = Files.lines(Paths.get(this.filename, new String[0]));){
            stream.forEach(this::readLine);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readLine(String line) {
        if (line.startsWith(COMMENT_PREFIX)) {
            return;
        }
        String[] tokens = line.split(SEPARATOR);
        if (tokens.length == 3) {
            GoId goId0 = this.factory.buildGoId(tokens[0]);
            GoId goId2 = this.factory.buildGoId(tokens[2]);
            if (tokens[1].equals(IS_A)) {
                this.add2Map(this.isParentMap, goId0, goId2);
                this.add2Map(this.isChildMap, goId2, goId0);
            } else if (tokens[1].equals(PART_OF)) {
                this.add2Map(this.isPartParentMap, goId0, goId2);
                this.add2Map(this.isPartChildMap, goId2, goId0);
            }
        }
    }

    private void add2Map(Map<GoId, List<GoId>> map, GoId key, GoId value) {
        List<GoId> values = map.get(key);
        if (values == null) {
            values = new ArrayList<GoId>();
            map.put(key, values);
        }
        values.add(value);
    }
}

