/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.uniparc;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.util.Crc64;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniparc.DbXrefConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniparc.SequenceFeatureConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniparc.AvroUniParc;

public class UniParcConverter
implements Converter<UniParcEntry, AvroUniParc> {
    private final DbXrefConverter xrefConverter = new DbXrefConverter();
    private final SequenceFeatureConverter sfConverter = new SequenceFeatureConverter();
    private final DefaultUniParcFactory factory = DefaultUniParcFactory.getInstance();

    @Override
    public AvroUniParc toAvro(UniParcEntry u) {
        AvroUniParc.Builder builder = AvroUniParc.newBuilder();
        builder.setSequence(u.getSequence().getValue()).setUpi(u.getUniParcId().getValue());
        builder.setXrefs(u.getDatabaseCrossReferences().stream().map(this.xrefConverter::toAvro).collect(Collectors.toList()));
        builder.setSeqfeatures(u.getSequenceFeatures().stream().map(this.sfConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    public UniParcEntry fromAvro(AvroUniParc a) {
        UniParcEntry entry = this.factory.buildEntry();
        entry.setUniParcId(this.factory.buildUniParcId(a.getUpi().toString()));
        entry.setSequence(this.createSequence(a.getSequence().toString()));
        entry.setDatabaseCrossReferences(a.getXrefs().stream().map(this.xrefConverter::fromAvro).collect(Collectors.toSet()));
        entry.setSequenceFeatures(a.getSeqfeatures().stream().map(this.sfConverter::fromAvro).collect(Collectors.toList()));
        return entry;
    }

    private Sequence createSequence(String seq) {
        Sequence sequence = this.factory.buildSequence(seq);
        sequence.setCRC64(Crc64.getCrc64(seq));
        return sequence;
    }
}

