/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdater;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.Thesis;

public class ThesisUpdater
implements CitationUpdater {
    private final DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public Object convertToAvro(Citation ci) {
        if (!(ci instanceof Thesis)) {
            return new Object();
        }
        Thesis val = (Thesis)ci;
        Thesis.Builder builder = uk.ac.ebi.uniprot.services.data.serializer.model.ref.Thesis.newBuilder();
        builder.setInstitute(val.getInstitute().getValue());
        builder.setPlace(val.getCity().getValue() + "; " + val.getCountry().getValue());
        return builder.build();
    }

    @Override
    public Citation update(Citation ci, Object obj) {
        if (!(ci instanceof Thesis)) {
            return ci;
        }
        Thesis val = (Thesis)ci;
        uk.ac.ebi.uniprot.services.data.serializer.model.ref.Thesis data = (uk.ac.ebi.uniprot.services.data.serializer.model.ref.Thesis)((Object)obj);
        if (data.getInstitute() != null) {
            val.setInstitute(this.factory.buildInstitute(data.getInstitute().toString()));
        }
        if (data.getPlace() != null) {
            String[] tokens = data.getPlace().toString().split("; ");
            if (tokens.length > 0) {
                val.setCity(this.factory.buildCity(tokens[0]));
            }
            if (tokens.length > 1) {
                val.setCountry(this.factory.buildCountry(tokens[1]));
            }
        }
        return val;
    }
}

