/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.proteome;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.ComponentType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.EntryType;
import uk.ac.ebi.uniprot.dataservice.domain.proteome.jaxb.ProteinType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroComponent;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.Protein;

public class AvroComponentConverter
implements Converter<ComponentType, AvroComponent> {
    private final AvroProteinConverter proteinConverter = new AvroProteinConverter();

    @Override
    public AvroComponent toAvro(ComponentType component) {
        AvroComponent.Builder builder = AvroComponent.newBuilder();
        if (component.getName() != null) {
            builder.setName(component.getName());
        }
        if (component.getDescription() != null) {
            builder.setDescription(component.getDescription());
        }
        if (component.getBiosampleId() != null) {
            builder.setBiosampleId(component.getBiosampleId());
        }
        if (component.getGenomeAccession() != null && !component.getGenomeAccession().isEmpty()) {
            builder.setGenomeAccession(component.getGenomeAccession().stream().map(val -> val).collect(Collectors.toList()));
        }
        if (component.getProtein() != null && !component.getProtein().isEmpty()) {
            builder.setProteins(component.getProtein().stream().map(val -> this.proteinConverter.toAvro((ProteinType)val)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    public ComponentType fromAvro(AvroComponent avro) {
        ComponentType component = new ComponentType();
        component.setName(avro.getName().toString());
        if (avro.getDescription() != null) {
            component.setDescription(avro.getDescription().toString());
        }
        if (avro.getBiosampleId() != null) {
            component.setBiosampleId(avro.getBiosampleId().toString());
        }
        if (avro.getGenomeAccession() != null) {
            avro.getGenomeAccession().forEach(val -> component.getGenomeAccession().add(val.toString()));
        }
        if (avro.getProteins() != null) {
            avro.getProteins().forEach(val -> component.getProtein().add(this.proteinConverter.fromAvro((Protein)((Object)val))));
        }
        return component;
    }

    static class AvroProteinConverter
    implements Converter<ProteinType, Protein> {
        AvroProteinConverter() {
        }

        @Override
        public Protein toAvro(ProteinType u) {
            Protein.Builder builder = Protein.newBuilder();
            builder.setAccession(u.getAccession());
            builder.setReviewed(u.getEntryType() == EntryType.SWISS_PROT);
            return builder.build();
        }

        @Override
        public ProteinType fromAvro(Protein a) {
            ProteinType protein = new ProteinType();
            protein.setAccession(a.getAccession().toString());
            if (a.getReviewed().booleanValue()) {
                protein.setEntryType(EntryType.SWISS_PROT);
            } else {
                protein.setEntryType(EntryType.TR_EMBL);
            }
            return protein;
        }
    }
}

