/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.gncoordinate;

import java.math.BigInteger;
import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.DbReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.EvidenceType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.ExonMapType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GenomicLocationType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GnCoordinateType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.GnFeatureType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.LocationType;
import uk.ac.ebi.uniprot.dataservice.domain.coordinate.jaxb.PositionType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnCoordinate;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnEvidence;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnExon;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnFeature;
import uk.ac.ebi.uniprot.services.data.serializer.model.coordinate.GnLocation;

class GnCoordinateAvroXmlConverter
implements Converter<GnCoordinateType, GnCoordinate> {
    private final ExonAvroXmlConverter exonConverter = new ExonAvroXmlConverter();
    private final GnFeatureAvroXmlConverter featureConverter = new GnFeatureAvroXmlConverter();

    GnCoordinateAvroXmlConverter() {
    }

    @Override
    public GnCoordinate toAvro(GnCoordinateType u) {
        GnCoordinate.Builder builder = GnCoordinate.newBuilder();
        builder.setChromosome(u.getGenomicLocation().getChromosome());
        builder.setEnsg(u.getEnsemblGeneId());
        builder.setEnsp(u.getEnsemblTranslationId());
        builder.setEnst(u.getEnsemblTranscriptId());
        builder.setLocation(this.createLocation(u.getGenomicLocation().getStart(), u.getGenomicLocation().getEnd()));
        builder.setReverseStrand(u.getGenomicLocation().isReverseStrand());
        if (u.getGenomicLocation().getExon() != null && !u.getGenomicLocation().getExon().isEmpty()) {
            builder.setExons(u.getGenomicLocation().getExon().stream().map(val -> this.exonConverter.toAvro((ExonMapType)val)).collect(Collectors.toList()));
        }
        if (u.getFeature() != null && !u.getFeature().isEmpty()) {
            builder.setFeatures(u.getFeature().stream().map(val -> this.featureConverter.toAvro((GnFeatureType)val)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    public GnCoordinateType fromAvro(GnCoordinate a) {
        GnCoordinateType coordinate = new GnCoordinateType();
        coordinate.setEnsemblGeneId(a.getEnsg().toString());
        coordinate.setEnsemblTranscriptId(a.getEnst().toString());
        coordinate.setEnsemblTranslationId(a.getEnsp().toString());
        GenomicLocationType gnLocation = new GenomicLocationType();
        gnLocation.setReverseStrand(a.getReverseStrand());
        if (a.getChromosome() != null) {
            gnLocation.setChromosome(a.getChromosome().toString());
        }
        gnLocation.setStart(a.getLocation().getStart());
        gnLocation.setEnd(a.getLocation().getEnd());
        if (a.getExons() != null && !a.getExons().isEmpty()) {
            a.getExons().stream().map(val -> this.exonConverter.fromAvro((GnExon)((Object)val))).forEach(val -> gnLocation.getExon().add((ExonMapType)val));
        }
        if (a.getFeatures() != null && !a.getFeatures().isEmpty()) {
            a.getFeatures().stream().map(val -> this.featureConverter.fromAvro((GnFeature)((Object)val))).forEach(val -> coordinate.getFeature().add((GnFeatureType)val));
        }
        coordinate.setGenomicLocation(gnLocation);
        return coordinate;
    }

    private GnLocation createLocation(long start, long end) {
        GnLocation.Builder builder = GnLocation.newBuilder();
        builder.setStart(start);
        builder.setEnd(end);
        return builder.build();
    }

    static class EvidenceAvroXmlConverter
    implements Converter<EvidenceType, GnEvidence> {
        EvidenceAvroXmlConverter() {
        }

        @Override
        public GnEvidence toAvro(EvidenceType evidence) {
            GnEvidence.Builder builder = GnEvidence.newBuilder();
            builder.setEco(evidence.getCode());
            if (evidence.getDbReference() != null) {
                builder.setDatabase(evidence.getDbReference().getType());
                builder.setDbId(evidence.getDbReference().getId());
            }
            return builder.build();
        }

        @Override
        public EvidenceType fromAvro(GnEvidence evidence) {
            EvidenceType evidenceType = new EvidenceType();
            if (evidence.getEco() != null) {
                evidenceType.setCode(evidence.getEco().toString());
            }
            DbReferenceType dbReferenceType = null;
            if (evidence.getDbId() != null || evidence.getDatabase() != null) {
                dbReferenceType = new DbReferenceType();
                if (evidence.getDbId() != null) {
                    dbReferenceType.setId(evidence.getDbId().toString());
                }
                if (evidence.getDatabase() != null) {
                    dbReferenceType.setType(evidence.getDatabase().toString());
                }
            }
            evidenceType.setDbReference(dbReferenceType);
            return evidenceType;
        }
    }

    static class GnFeatureAvroXmlConverter
    implements Converter<GnFeatureType, GnFeature> {
        private final LocationAvroXmlConverter locationConverter = new LocationAvroXmlConverter();
        private final EvidenceAvroXmlConverter evidenceConverter = new EvidenceAvroXmlConverter();

        GnFeatureAvroXmlConverter() {
        }

        @Override
        public GnFeature toAvro(GnFeatureType u) {
            GnFeature.Builder builder = GnFeature.newBuilder();
            builder.setType(u.getType());
            builder.setDescription(u.getDescription());
            builder.setFtId(u.getId());
            builder.setProteinLocation(this.locationConverter.toAvro(u.getLocation()));
            builder.setGenomeLocation(this.locationConverter.toAvro(u.getGenomeLocation()));
            if (u.getOriginal() != null && !u.getOriginal().isEmpty()) {
                builder.setOriginal(u.getOriginal());
            }
            if (u.getVariation() != null && !u.getVariation().isEmpty()) {
                builder.setVariant(u.getVariation().stream().collect(Collectors.joining(",")));
            }
            if (u.getEvidence() != null && !u.getEvidence().isEmpty()) {
                builder.setEvidences(u.getEvidence().stream().map(val -> this.evidenceConverter.toAvro((EvidenceType)val)).collect(Collectors.toList()));
            }
            return builder.build();
        }

        @Override
        public GnFeatureType fromAvro(GnFeature a) {
            GnFeatureType feature = new GnFeatureType();
            feature.setType(a.getType().toString());
            if (a.getDescription() != null) {
                feature.setDescription(a.getDescription().toString());
            }
            if (a.getFtId() != null) {
                feature.setId(a.getFtId().toString());
            }
            feature.setLocation(this.locationConverter.fromAvro(a.getProteinLocation()));
            feature.setGenomeLocation(this.locationConverter.fromAvro(a.getGenomeLocation()));
            if (a.getOriginal() != null && a.getOriginal().length() > 0) {
                feature.setOriginal(a.getOriginal().toString());
            }
            if (a.getVariant() != null && a.getVariant().length() > 0) {
                String[] tokens;
                String variant = a.getVariant().toString();
                for (String token : tokens = variant.split(",")) {
                    feature.getVariation().add(token);
                }
            }
            if (a.getEvidences() != null && !a.getEvidences().isEmpty()) {
                a.getEvidences().stream().map(val -> this.evidenceConverter.fromAvro((GnEvidence)((Object)val))).forEach(val -> feature.getEvidence().add((EvidenceType)val));
            }
            return feature;
        }
    }

    static class LocationAvroXmlConverter
    implements Converter<LocationType, GnLocation> {
        LocationAvroXmlConverter() {
        }

        @Override
        public GnLocation toAvro(LocationType u) {
            GnLocation.Builder builder = GnLocation.newBuilder();
            if (u.getBegin() != null) {
                builder.setStart(u.getBegin().getPosition().longValue());
            } else {
                builder.setStart(u.getPosition().getPosition().longValue());
            }
            if (u.getEnd() != null) {
                builder.setEnd(u.getEnd().getPosition().longValue());
            } else {
                builder.setEnd(u.getPosition().getPosition().longValue());
            }
            return builder.build();
        }

        @Override
        public LocationType fromAvro(GnLocation a) {
            LocationType location = new LocationType();
            if (a.getStart().equals(a.getEnd())) {
                PositionType pos = new PositionType();
                pos.setPosition(BigInteger.valueOf(a.getStart()));
                location.setPosition(pos);
                return location;
            }
            PositionType begin = new PositionType();
            begin.setPosition(BigInteger.valueOf(a.getStart()));
            location.setBegin(begin);
            PositionType end = new PositionType();
            end.setPosition(BigInteger.valueOf(a.getEnd()));
            location.setEnd(end);
            return location;
        }
    }

    static class ExonAvroXmlConverter
    implements Converter<ExonMapType, GnExon> {
        private final LocationAvroXmlConverter locationConverter = new LocationAvroXmlConverter();

        ExonAvroXmlConverter() {
        }

        @Override
        public GnExon toAvro(ExonMapType u) {
            GnExon.Builder builder = GnExon.newBuilder();
            builder.setId(u.getId());
            builder.setProteinLocation(this.locationConverter.toAvro(u.getProteinLocation()));
            builder.setGenomeLocation(this.locationConverter.toAvro(u.getGenomeLocation()));
            return builder.build();
        }

        @Override
        public ExonMapType fromAvro(GnExon a) {
            ExonMapType exon = new ExonMapType();
            exon.setId(a.getId().toString());
            exon.setProteinLocation(this.locationConverter.fromAvro(a.getProteinLocation()));
            exon.setGenomeLocation(this.locationConverter.fromAvro(a.getGenomeLocation()));
            return exon;
        }
    }
}

