/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.feature;

import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.DbReferenceType;
import uk.ac.ebi.uniprot.dataservice.domain.feature.jaxb.PropertyType;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.AvroXref;
import uk.ac.ebi.uniprot.services.data.serializer.model.proteome.Pair;

public class DbXrefConverter
implements Converter<DbReferenceType, AvroXref> {
    @Override
    public AvroXref toAvro(DbReferenceType xref) {
        AvroXref.Builder builder = AvroXref.newBuilder();
        builder.setType(xref.getType());
        builder.setId(xref.getId());
        if (xref.getProperty() != null && !xref.getProperty().isEmpty()) {
            builder.setProperties(xref.getProperty().stream().map(val -> this.toAvro((PropertyType)val)).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @Override
    public DbReferenceType fromAvro(AvroXref avro) {
        DbReferenceType xref = new DbReferenceType();
        xref.setType(avro.getType().toString());
        xref.setId(avro.getId().toString());
        if (avro.getProperties() != null) {
            avro.getProperties().stream().map(val -> this.fromAvro((Pair)((Object)val))).forEach(prop -> xref.getProperty().add((PropertyType)prop));
        }
        return xref;
    }

    @Override
    private Pair toAvro(PropertyType property) {
        Pair.Builder builder = Pair.newBuilder();
        builder.setKey(property.getType());
        builder.setValue(property.getValue());
        return builder.build();
    }

    @Override
    private PropertyType fromAvro(Pair pair) {
        PropertyType property = new PropertyType();
        property.setType(pair.getKey().toString());
        property.setValue(pair.getValue().toString());
        return property;
    }
}

