/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentText;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.TextComment;

public class TextOnlyCommentConverter
extends AbstractCommentConverter<TextOnlyComment> {
    @Override
    protected Object convertToAvro(TextOnlyComment comment) {
        TextComment.Builder builder = TextComment.newBuilder();
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            builder.setMolecule(comment.getMolecule());
        }
        builder.setTexts(comment.getTexts().stream().map(t -> ConverterHelper.convert(t.getValue(), t.getEvidenceIds())).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    protected TextOnlyComment convertFromAvro(CommentType type, Object avroObj) {
        TextOnlyComment comment = (TextOnlyComment)factory.buildComment(type);
        TextComment tc = (TextComment)((Object)avroObj);
        if (tc.getMolecule() != null) {
            comment.setMolecule(tc.getMolecule().toString());
        }
        comment.setTexts(tc.getTexts().stream().map(es -> {
            CommentText ct = factory.buildCommentText();
            ct.setCommentStatus(CommentStatus.EXPERIMENTAL);
            ct.setValue(es.getKey().toString());
            ct.setEvidenceIds(evidenceConverter.fromAvro(es.getEvidence()));
            return ct;
        }).collect(Collectors.toList()));
        return comment;
    }
}

