/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.AbstractCommentConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.PhysiologicalReactionConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.comment.ReactionConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.CatalyticActivity;

public class CatalyticActivityCommentConverter
extends AbstractCommentConverter<CatalyticActivityCommentStructured> {
    private final CommentFactory factory = DefaultCommentFactory.getInstance();
    private final ReactionConverter reactionConverter = new ReactionConverter();
    private final PhysiologicalReactionConverter physioReactionConverter = new PhysiologicalReactionConverter();

    @Override
    protected Object convertToAvro(CatalyticActivityCommentStructured comment) {
        CatalyticActivity.Builder builder = CatalyticActivity.newBuilder();
        if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
            builder.setMolecule(comment.getMolecule());
        }
        if (comment.getReaction() != null) {
            builder.setReaction(this.reactionConverter.toAvro(comment.getReaction()));
        }
        builder.setPhysiologicalReactions(comment.getPhysiologicalReactions().stream().map(this.physioReactionConverter::toAvro).collect(Collectors.toList()));
        return builder.build();
    }

    @Override
    protected CatalyticActivityCommentStructured convertFromAvro(CommentType type, Object avroObj) {
        CatalyticActivityCommentStructured comment = (CatalyticActivityCommentStructured)this.factory.buildComment(type);
        CatalyticActivity ca = (CatalyticActivity)((Object)avroObj);
        if (ca.getMolecule() != null) {
            comment.setMolecule(ca.getMolecule().toString());
        }
        if (ca.getReaction() != null) {
            comment.setReaction(this.reactionConverter.fromAvro(ca.getReaction()));
        }
        comment.setPhysiologicalReactions(ca.getPhysiologicalReactions().stream().map(this.physioReactionConverter::fromAvro).collect(Collectors.toList()));
        return comment;
    }
}

