/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;
import uk.ac.ebi.kraken.parser.translator.FeatureTranslator;

public class UniProtDocumentHelper {
    private static final DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private static final String ORF_NAME = "ORFName=";
    private static final String OLN = "OLN=";
    private static final String SYNONYM = "Synonym=";
    private static final String NAME = "Name=";
    private static final FeatureTranslator featureTranslator = new FeatureTranslator();
    private static final String gene_regex = "^(Name=[^;]+)?;?\\s?(Synonym=[^;]+)?(;\\s)?(OLN=[^;]+)?(;\\s)?(ORFName=[^;]+)?$";
    private static final Pattern genePatten = Pattern.compile("^(Name=[^;]+)?;?\\s?(Synonym=[^;]+)?(;\\s)?(OLN=[^;]+)?(;\\s)?(ORFName=[^;]+)?$");
    private static final String dbxref_regex = "^([^;]+); ([^;]+); ([^;]+)(; [^;]+)?(; [^;]+)?\\.(\\s\\[.+\\])?$";
    private static final Pattern xrefPatten = Pattern.compile("^([^;]+); ([^;]+); ([^;]+)(; [^;]+)?(; [^;]+)?\\.(\\s\\[.+\\])?$");

    public static String geneToString(Gene gene) {
        StringBuilder sb = new StringBuilder();
        if (gene.hasGeneName()) {
            sb.append(NAME).append(gene.getGeneName().getValue()).append("; ");
        }
        if (!gene.getGeneNameSynonyms().isEmpty()) {
            sb.append(SYNONYM);
            sb.append(UniProtDocumentHelper.buildValues(gene.getGeneNameSynonyms()));
            sb.append("; ");
        }
        if (!gene.getOrderedLocusNames().isEmpty()) {
            sb.append(OLN);
            sb.append(UniProtDocumentHelper.buildValues(gene.getOrderedLocusNames()));
            sb.append("; ");
        }
        if (!gene.getORFNames().isEmpty()) {
            sb.append(ORF_NAME);
            sb.append(UniProtDocumentHelper.buildValues(gene.getORFNames()));
            sb.append("; ");
        }
        return sb.toString().substring(0, sb.length() - 2);
    }

    public static Gene stringToGene(String value) {
        Matcher matcher = genePatten.matcher(value);
        Gene gene = factory.buildGene();
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String[] syVals;
                String val;
                String token = matcher.group(i);
                if (token == null) continue;
                if (token.startsWith(NAME)) {
                    GeneName name = factory.buildGeneName(token.substring(NAME.length()));
                    gene.setGeneName(name);
                }
                if (token.startsWith(SYNONYM)) {
                    val = token.substring(SYNONYM.length());
                    for (String sy : syVals = val.split(", ")) {
                        gene.getGeneNameSynonyms().add(factory.buildGeneNameSynonym(sy));
                    }
                }
                if (token.startsWith(OLN)) {
                    val = token.substring(OLN.length());
                    for (String sy : syVals = val.split(", ")) {
                        gene.getOrderedLocusNames().add(factory.buildOrderedLocusName(sy));
                    }
                }
                if (!token.startsWith(ORF_NAME)) continue;
                val = token.substring(ORF_NAME.length());
                for (String sy : syVals = val.split(", ")) {
                    gene.getORFNames().add(factory.buildORFName(sy));
                }
            }
        }
        return gene;
    }

    public static DatabaseCrossReference stringToDBXref(String value) {
        Matcher matcher = xrefPatten.matcher(value);
        DefaultXRefFactory xfactory = DefaultXRefFactory.getInstance();
        if (matcher.matches()) {
            String db = matcher.group(1);
            String primaryId = matcher.group(2);
            String description = matcher.group(3);
            String third = matcher.group(4);
            String fourth = matcher.group(5);
            String isoform = matcher.group(6);
            DatabaseCrossReference xref = xfactory.buildDatabaseCrossReference(db);
            xref.setPrimaryId(xfactory.buildXDBAttribute(primaryId));
            xref.setDescription(xfactory.buildXDBAttribute(description));
            if (third != null) {
                xref.setThird(xfactory.buildXDBAttribute(third.substring(2)));
            }
            if (fourth != null) {
                xref.setFourth(xfactory.buildXDBAttribute(fourth.substring(2)));
            }
            if (isoform != null) {
                xref.setIsoformId(factory.buildUniProtIsoformId(isoform.substring(2, isoform.length() - 1)));
            }
            return xref;
        }
        return null;
    }

    public static DatabaseCrossReference stringToDBXref2(String value) {
        DefaultXRefFactory xfactory = DefaultXRefFactory.getInstance();
        String isoform = "";
        if (value.endsWith("]")) {
            isoform = value.substring(value.lastIndexOf(91) + 1, value.length() - 1);
            value = value.substring(0, value.lastIndexOf(91)).trim();
        }
        value = value.substring(0, value.length() - 1);
        String[] tokens = value.split("; ");
        DatabaseCrossReference xref = xfactory.buildDatabaseCrossReference(tokens[0]);
        xref.setPrimaryId(xfactory.buildXDBAttribute(tokens[1]));
        xref.setDescription(xfactory.buildXDBAttribute(tokens[2]));
        if (tokens.length > 3) {
            xref.setThird(xfactory.buildXDBAttribute(tokens[3]));
        }
        if (tokens.length > 4) {
            xref.setFourth(xfactory.buildXDBAttribute(tokens[4]));
        }
        if (!isoform.isEmpty()) {
            xref.setIsoformId(factory.buildUniProtIsoformId(isoform));
        }
        return xref;
    }

    public static Feature string2Feature(String val) {
        return featureTranslator.translate(val);
    }

    public static Comment string2Comment(String val) {
        int index = val.indexOf(":");
        String type = val.substring(0, index);
        val = val.substring(index + 1).trim();
        CommentType commentType = CommentType.typeOf(type);
        return CommentTranslatorHelper.translate(val, commentType);
    }

    private static String buildValues(List<? extends Value> values) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Value value : values) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(value.getValue());
            isFirst = false;
        }
        return sb.toString();
    }
}

