/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.HasCommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureStatus;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;

public class ConverterHelper {
    private static final String POTENTIAL = " (Potential)";
    private static final String POTENTIAL_2 = " (potential)";
    private static final String PROBABLE = " (Probable)";
    private static final String PROBABLE_2 = " (probable)";
    private static final String BY_SIMILARITY = " (By similarity)";
    private static final String BY_SIMILARITY_2 = " (by similarity)";
    private static EvidenceConverter evidenceConverter = new EvidenceConverter();

    public static EvidencedString convert(String value, List<EvidenceId> evidences) {
        EvidencedString.Builder valueBuilder = EvidencedString.newBuilder();
        valueBuilder.setKey(value);
        valueBuilder.setEvidence(evidenceConverter.toAvro(evidences));
        return valueBuilder.build();
    }

    public static String buildCommentStatus(HasCommentStatus comment) {
        String extra = "";
        if (comment.getCommentStatus() == CommentStatus.BY_SIMILARITY) {
            extra = extra + BY_SIMILARITY;
        } else if (comment.getCommentStatus() == CommentStatus.PROBABLE) {
            extra = extra + PROBABLE;
        } else if (comment.getCommentStatus() == CommentStatus.POTENTIAL) {
            extra = extra + POTENTIAL;
        }
        return extra;
    }

    public static String setCommentStatus(String annotation, HasCommentStatus comment) {
        if (annotation.endsWith(POTENTIAL) || annotation.endsWith(POTENTIAL_2)) {
            comment.setCommentStatus(CommentStatus.POTENTIAL);
            annotation = annotation.substring(0, annotation.length() - 12);
        } else if (annotation.endsWith(PROBABLE) || annotation.endsWith(PROBABLE_2)) {
            comment.setCommentStatus(CommentStatus.PROBABLE);
            annotation = annotation.substring(0, annotation.length() - 11);
        } else if (annotation.endsWith(BY_SIMILARITY) || annotation.endsWith(BY_SIMILARITY_2)) {
            comment.setCommentStatus(CommentStatus.BY_SIMILARITY);
            annotation = annotation.substring(0, annotation.length() - 16);
        } else {
            comment.setCommentStatus(CommentStatus.EXPERIMENTAL);
        }
        return annotation;
    }

    public static String getFeatureStatusStr(HasFeatureStatus feature) {
        if (feature.getFeatureStatus() == FeatureStatus.BY_SIMILARITY) {
            return BY_SIMILARITY;
        }
        if (feature.getFeatureStatus() == FeatureStatus.POTENTIAL) {
            return POTENTIAL;
        }
        if (feature.getFeatureStatus() == FeatureStatus.PROBABLE) {
            return PROBABLE;
        }
        return "";
    }
}

