/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationPositionConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationTypeConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdater;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdaterFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationXrefConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.RefCommentConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.Publication;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.RefComment;

public class CitationConverter
implements Converter<Citation, Publication> {
    private static DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();
    private final CitationTypeConverter typeConverter = new CitationTypeConverter();
    private final CitationPositionConverter positionConverter = new CitationPositionConverter();
    private final CitationXrefConverter xrefConverter = new CitationXrefConverter();
    private final RefCommentConverter refCommentConverter = new RefCommentConverter();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Publication toAvro(Citation u) {
        Publication.Builder builder = Publication.newBuilder();
        builder.setType(this.typeConverter.toAvro(u.getCitationType()));
        builder.setAuthor(u.getAuthors().stream().map(au -> au.getValue()).collect(Collectors.toList()));
        builder.setOrganization(u.getAuthoringGroup().stream().map(au -> au.getValue()).collect(Collectors.toList()));
        builder.setDate(u.getPublicationDate().getValue());
        builder.setTitle(u.getTitle().getValue());
        builder.setScope(this.positionConverter.toAvro(u.getCitationSummary()));
        builder.setXref(this.xrefConverter.toAvro(u.getCitationXrefs()));
        builder.setCitation(CitationUpdaterFactory.INSTANCE.getUpdater(u.getCitationType()).convertToAvro(u));
        ArrayList<RefComment> refComments = new ArrayList<RefComment>();
        for (SampleSource ss : u.getSampleSources()) {
            refComments.add(this.refCommentConverter.toAvro(ss));
        }
        builder.setComments(refComments);
        builder.setEvidence(this.evidenceConverter.toAvro(u.getEvidenceIds()));
        return builder.build();
    }

    @Override
    public Citation fromAvro(Publication a) {
        Object citation = factory.buildCitation(this.typeConverter.fromAvro(a.getType()));
        citation.setAuthors(a.getAuthor().stream().map(au -> factory.buildAuthor(au.toString())).collect(Collectors.toList()));
        citation.setAuthoringGroup(a.getOrganization().stream().map(au -> factory.buildAuthoringGroup(au.toString())).collect(Collectors.toList()));
        citation.setPublicationDate(factory.buildPublicationDate(a.getDate().toString()));
        citation.setTitle(a.getTitle().toString());
        citation.setCitationSummary(this.positionConverter.fromAvro(a.getScope().toString()));
        citation.setCitationsXrefs(this.xrefConverter.fromAvro(a.getXref()));
        CitationUpdater citationUpdater = CitationUpdaterFactory.INSTANCE.getUpdater(citation.getCitationType());
        citationUpdater.update((Citation)citation, a.getCitation());
        ArrayList<SampleSource> sss = new ArrayList<SampleSource>();
        for (RefComment refCom : a.getComments()) {
            sss.add(this.refCommentConverter.fromAvro(refCom));
        }
        citation.setSampleSources(sss);
        citation.setEvidenceIds(this.evidenceConverter.fromAvro(a.getEvidence()));
        return citation;
    }
}

