/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.document.uniprot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.beans.Field;
import uk.ac.ebi.uniprot.dataservice.annotation.DocumentTypeEnum;
import uk.ac.ebi.uniprot.dataservice.annotation.SupportedDocumentType;
import uk.ac.ebi.uniprot.dataservice.document.Document;

@SupportedDocumentType(types={DocumentTypeEnum.UNIPROT})
public class UniProtDocument
implements Document {
    @Field(value="accession")
    public String accession;
    @Field(value="sec_acc")
    public List<String> secacc = new ArrayList<String>();
    @Field(value="id")
    public String id;
    @Field(value="reviewed")
    public Boolean reviewed;
    @Field(value="protein_name")
    public List<String> proteinNames = new ArrayList<String>();
    @Field(value="ec")
    public List<String> ecNumbers = new ArrayList<String>();
    @Field(value="go_terms")
    public List<String> goTerms = new ArrayList<String>();
    @Field(value="updated")
    public Date lastModified;
    @Field(value="created")
    public Date firstCreated;
    @Field(value="sequence_updated")
    public Date sequenceUpdated;
    @Field(value="keywords")
    public List<String> keywords = new ArrayList<String>();
    @Field(value="gene")
    public List<String> geneNames = new ArrayList<String>();
    @Field(value="gene_exact")
    public List<String> geneNamesExact = new ArrayList<String>();
    @Deprecated
    @Field(value="gene_stored")
    public List<String> geneNameStored = new ArrayList<String>();
    @Field(value="organism_name")
    public List<String> organismNames = new ArrayList<String>();
    @Field(value="organism_tax_id")
    public int organismTaxId;
    @Field(value="tax_name_lineage")
    public List<String> organismTaxon = new ArrayList<String>();
    @Field(value="tax_id_lineage")
    public List<Integer> taxLineageIds = new ArrayList<Integer>();
    @Field(value="organelles")
    public List<String> organelles = new ArrayList<String>();
    @Field(value="organism_host_name")
    public List<String> organismHostNames = new ArrayList<String>();
    @Field(value="organism_host_tax_id")
    public List<Integer> organismHostIds = new ArrayList<Integer>();
    @Deprecated
    @Field(value="xrefs")
    public List<String> xrefs = new ArrayList<String>();
    @Field(value="xref_*")
    public Map<String, Collection<String>> xrefMap = new HashMap<String, Collection<String>>();
    @Field(value="lit_titles")
    public List<String> referenceTitles = new ArrayList<String>();
    @Field(value="lit_authors")
    public List<String> referenceAuthors = new ArrayList<String>();
    @Field(value="lit_pubmed")
    public List<String> referencePubmeds = new ArrayList<String>();
    @Field(value="lit_organisations")
    public List<String> referenceOrganizations = new ArrayList<String>();
    @Field(value="lit_pubdate")
    public List<Date> referenceDates = new ArrayList<Date>();
    @Field(value="comment_*")
    public Map<String, Collection<String>> commentMap = new HashMap<String, Collection<String>>();
    @Field(value="comments")
    public List<String> comments = new ArrayList<String>();
    @Field(value="features_*")
    public Map<String, Collection<String>> featuresMap = new HashMap<String, Collection<String>>();
    @Deprecated
    @Field(value="features")
    public List<String> features = new ArrayList<String>();
    @Field(value="ft_start")
    public Set<Integer> ftPosStart = new HashSet<Integer>();
    @Field(value="ft_end")
    public Set<Integer> ftPosEnd = new HashSet<Integer>();
    @Field(value="protein_existence")
    public String proteinExistence;
    @Field(value="fragment")
    public boolean fragment;
    @Field(value="precursor")
    public boolean precursor;
    @Field(value="md5")
    public String md5;
    @Field(value="active")
    public boolean active = true;
    @Field(value="cc_cofactor_chebi")
    public Set<String> cofactorChebi = new HashSet<String>();
    @Field(value="cc_cofactor_note")
    public Set<String> cofactorNote = new HashSet<String>();
    @Field(value="cc_bpcp_absorption")
    public Set<String> bpcpAbsorption = new HashSet<String>();
    @Field(value="cc_bpcp_kinetics")
    public Set<String> bpcpKinetics = new HashSet<String>();
    @Field(value="cc_bpcp_ph_dependence")
    public Set<String> bpcpPhDependence = new HashSet<String>();
    @Field(value="cc_bpcp_redox_potential")
    public Set<String> bpcpRedoxPotential = new HashSet<String>();
    @Field(value="cc_bpcp_temp_dependence")
    public Set<String> bpcpTempDependence = new HashSet<String>();
    @Field(value="cc_scl_term")
    public Set<String> subcellLocationTerm = new HashSet<String>();
    @Field(value="cc_scl_note")
    public Set<String> subcellLocationNote = new HashSet<String>();
    @Field(value="cc_ap_event")
    public Set<String> apEvent = new HashSet<String>();
    @Field(value="cc_sc_type")
    public Set<String> seqCautionType = new HashSet<String>();
    @Field(value="evidence")
    public Set<String> evidences = new HashSet<String>();
    @Field(value="mass")
    public int seqMass;
    @Field(value="length")
    public int seqLength;
    @Field(value="rc_tissue")
    public Set<String> rcTissue = new HashSet<String>();
    @Field(value="rc_strain")
    public Set<String> rcStrain = new HashSet<String>();
    @Field(value="rc_plasmid")
    public Set<String> rcPlasmid = new HashSet<String>();
    @Field(value="rc_transposon")
    public Set<String> rcTransposon = new HashSet<String>();
    @Field(value="go_evidence")
    public Set<String> goEvidence = new HashSet<String>();
    @Field(value="go_with_evidence")
    public Set<String> goWithEvidence = new HashSet<String>();
    @Field(value="avro_binary")
    public byte[] avro_binray;
    @Field(value="avro_json")
    public String avro_json;
    @Field(value="is_isoform")
    public Boolean isIsoform = false;
    public String file_path;
    public long obj_offset;
    public long obj_location;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniProtDocument)) {
            return false;
        }
        UniProtDocument that = (UniProtDocument)o;
        if (this.fragment != that.fragment) {
            return false;
        }
        if (this.organismTaxId != that.organismTaxId) {
            return false;
        }
        if (this.reviewed != that.reviewed) {
            return false;
        }
        if (this.accession != null ? !this.accession.equals(that.accession) : that.accession != null) {
            return false;
        }
        if (this.commentMap != null ? !this.commentMap.equals(that.commentMap) : that.commentMap != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.ecNumbers != null ? !this.ecNumbers.equals(that.ecNumbers) : that.ecNumbers != null) {
            return false;
        }
        if (this.featuresMap != null ? !this.featuresMap.equals(that.featuresMap) : that.featuresMap != null) {
            return false;
        }
        if (this.firstCreated != null ? !this.firstCreated.equals(that.firstCreated) : that.firstCreated != null) {
            return false;
        }
        if (this.ftPosEnd != null ? !this.ftPosEnd.equals(that.ftPosEnd) : that.ftPosEnd != null) {
            return false;
        }
        if (this.ftPosStart != null ? !this.ftPosStart.equals(that.ftPosStart) : that.ftPosStart != null) {
            return false;
        }
        if (this.geneNames != null ? !this.geneNames.equals(that.geneNames) : that.geneNames != null) {
            return false;
        }
        if (this.geneNamesExact != null ? !this.geneNamesExact.equals(that.geneNamesExact) : that.geneNamesExact != null) {
            return false;
        }
        if (this.goTerms != null ? !this.goTerms.equals(that.goTerms) : that.goTerms != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.organelles != null ? !this.organelles.equals(that.organelles) : that.organelles != null) {
            return false;
        }
        if (this.organismHostIds != null ? !this.organismHostIds.equals(that.organismHostIds) : that.organismHostIds != null) {
            return false;
        }
        if (this.organismHostNames != null ? !this.organismHostNames.equals(that.organismHostNames) : that.organismHostNames != null) {
            return false;
        }
        if (this.organismNames != null ? !this.organismNames.equals(that.organismNames) : that.organismNames != null) {
            return false;
        }
        if (this.organismTaxon != null ? !this.organismTaxon.equals(that.organismTaxon) : that.organismTaxon != null) {
            return false;
        }
        if (this.proteinExistence != null ? !this.proteinExistence.equals(that.proteinExistence) : that.proteinExistence != null) {
            return false;
        }
        if (this.proteinNames != null ? !this.proteinNames.equals(that.proteinNames) : that.proteinNames != null) {
            return false;
        }
        if (this.referenceAuthors != null ? !this.referenceAuthors.equals(that.referenceAuthors) : that.referenceAuthors != null) {
            return false;
        }
        if (this.referenceDates != null ? !this.referenceDates.equals(that.referenceDates) : that.referenceDates != null) {
            return false;
        }
        if (this.referenceOrganizations != null ? !this.referenceOrganizations.equals(that.referenceOrganizations) : that.referenceOrganizations != null) {
            return false;
        }
        if (this.referencePubmeds != null ? !this.referencePubmeds.equals(that.referencePubmeds) : that.referencePubmeds != null) {
            return false;
        }
        if (this.referenceTitles != null ? !this.referenceTitles.equals(that.referenceTitles) : that.referenceTitles != null) {
            return false;
        }
        if (this.secacc != null ? !this.secacc.equals(that.secacc) : that.secacc != null) {
            return false;
        }
        if (this.taxLineageIds != null ? !this.taxLineageIds.equals(that.taxLineageIds) : that.taxLineageIds != null) {
            return false;
        }
        return !(this.xrefMap != null ? !this.xrefMap.equals(that.xrefMap) : that.xrefMap != null);
    }

    public int hashCode() {
        int result = this.accession != null ? this.accession.hashCode() : 0;
        result = 31 * result + (this.secacc != null ? this.secacc.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.reviewed != false ? 1 : 0);
        result = 31 * result + (this.proteinNames != null ? this.proteinNames.hashCode() : 0);
        result = 31 * result + (this.ecNumbers != null ? this.ecNumbers.hashCode() : 0);
        result = 31 * result + (this.goTerms != null ? this.goTerms.hashCode() : 0);
        result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
        result = 31 * result + (this.firstCreated != null ? this.firstCreated.hashCode() : 0);
        result = 31 * result + (this.keywords != null ? this.keywords.hashCode() : 0);
        result = 31 * result + (this.geneNames != null ? this.geneNames.hashCode() : 0);
        result = 31 * result + (this.geneNamesExact != null ? this.geneNamesExact.hashCode() : 0);
        result = 31 * result + (this.organismNames != null ? this.organismNames.hashCode() : 0);
        result = 31 * result + this.organismTaxId;
        result = 31 * result + (this.organismTaxon != null ? this.organismTaxon.hashCode() : 0);
        result = 31 * result + (this.taxLineageIds != null ? this.taxLineageIds.hashCode() : 0);
        result = 31 * result + (this.organelles != null ? this.organelles.hashCode() : 0);
        result = 31 * result + (this.organismHostNames != null ? this.organismHostNames.hashCode() : 0);
        result = 31 * result + (this.organismHostIds != null ? this.organismHostIds.hashCode() : 0);
        result = 31 * result + (this.xrefMap != null ? this.xrefMap.hashCode() : 0);
        result = 31 * result + (this.referenceTitles != null ? this.referenceTitles.hashCode() : 0);
        result = 31 * result + (this.referenceAuthors != null ? this.referenceAuthors.hashCode() : 0);
        result = 31 * result + (this.referencePubmeds != null ? this.referencePubmeds.hashCode() : 0);
        result = 31 * result + (this.referenceOrganizations != null ? this.referenceOrganizations.hashCode() : 0);
        result = 31 * result + (this.referenceDates != null ? this.referenceDates.hashCode() : 0);
        result = 31 * result + (this.commentMap != null ? this.commentMap.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.featuresMap != null ? this.featuresMap.hashCode() : 0);
        result = 31 * result + (this.ftPosStart != null ? this.ftPosStart.hashCode() : 0);
        result = 31 * result + (this.ftPosEnd != null ? this.ftPosEnd.hashCode() : 0);
        result = 31 * result + (this.fragment ? 1 : 0);
        result = 31 * result + (this.proteinExistence != null ? this.proteinExistence.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UniProtDocument{accession='" + this.accession + '\'' + ", secacc=" + this.secacc + ", id='" + this.id + '\'' + ", reviewed=" + this.reviewed + ", proteinNames=" + this.proteinNames + ", ecNumbers=" + this.ecNumbers + ", goTerms=" + this.goTerms + ", lastModified=" + this.lastModified + ", firstCreated=" + this.firstCreated + ", keywords=" + this.keywords + ", geneNames=" + this.geneNames + ", geneNamesExact=" + this.geneNamesExact + ", organismNames=" + this.organismNames + ", organismTaxId=" + this.organismTaxId + ", organismTaxon=" + this.organismTaxon + ", taxLineageIds=" + this.taxLineageIds + ", organelles=" + this.organelles + ", organismHostNames=" + this.organismHostNames + ", organismHostIds=" + this.organismHostIds + ", xrefMap=" + this.xrefMap + ", referenceTitles=" + this.referenceTitles + ", referenceAuthors=" + this.referenceAuthors + ", referencePubmeds=" + this.referencePubmeds + ", referenceOrganizations=" + this.referenceOrganizations + ", referenceDates=" + this.referenceDates + ", commentMap=" + this.commentMap + ", comments=" + this.comments + ", featuresMap=" + this.featuresMap + ", ftPosStart=" + this.ftPosStart + ", ftPosEnd=" + this.ftPosEnd + ", fragment=" + this.fragment + ", proteinExistence='" + this.proteinExistence + '\'' + '}';
    }
}

