/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AbstractLazyHit;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;

class LazyUniProtHit
extends AbstractLazyHit<UniProtEntry>
implements UniProtHit {
    private UniProtBlastSummary summary;
    private final AbstractLazyHit.ReadEntryService<UniProtEntry> readEntryService;

    public LazyUniProtHit(UniProtBlastSummary summary, UniProtService searchService) {
        if (summary == null) {
            throw new IllegalArgumentException("Can not instantiate object with null summary");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("Can not instantiate object with null search service");
        }
        this.summary = summary;
        this.readEntryService = new UniProtReadEntryService(searchService);
    }

    @Override
    public UniProtEntry getEntry() {
        return this.getEntry(this.summary.getEntryAc(), this.readEntryService);
    }

    @Override
    public UniProtBlastSummary getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyUniProtHit)) {
            return false;
        }
        LazyUniProtHit that = (LazyUniProtHit)o;
        return this.summary.equals(that.summary);
    }

    public int hashCode() {
        return this.summary.hashCode();
    }

    public String toString() {
        return "UniProtHitImpl{summary=" + this.summary + '}';
    }

    private class UniProtReadEntryService
    implements AbstractLazyHit.ReadEntryService<UniProtEntry> {
        private UniProtService searchService;

        public UniProtReadEntryService(UniProtService searchService) {
            this.searchService = searchService;
        }

        @Override
        public UniProtEntry getEntry(String entryId) throws ServiceException {
            return this.searchService.getEntry(entryId);
        }
    }
}

