/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.Alignment;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;

class BlastSummaryImpl
implements BlastSummary {
    int hitNumber;
    String database;
    String entryId;
    long sequenceLength;
    String description;
    List<Alignment> alignments;

    public BlastSummaryImpl() {
    }

    public BlastSummaryImpl(BlastSummary blastSummary) {
        this.database = blastSummary.getDatabase();
        this.description = blastSummary.getDescription();
        this.entryId = blastSummary.getEntryId();
        this.hitNumber = blastSummary.getHitNumber();
        this.sequenceLength = blastSummary.getSequenceLength();
        this.alignments = new ArrayList<Alignment>(blastSummary.getAlignments());
    }

    @Override
    public int getHitNumber() {
        return this.hitNumber;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getEntryId() {
        return this.entryId;
    }

    @Override
    public long getSequenceLength() {
        return this.sequenceLength;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Alignment> getAlignments() {
        return this.alignments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlastSummaryImpl hit = (BlastSummaryImpl)o;
        if (this.hitNumber != hit.hitNumber) {
            return false;
        }
        if (this.sequenceLength != hit.sequenceLength) {
            return false;
        }
        if (!this.database.equals(hit.database)) {
            return false;
        }
        if (!this.entryId.equals(hit.entryId)) {
            return false;
        }
        if (!this.description.equals(hit.description)) {
            return false;
        }
        return this.alignments.equals(hit.alignments);
    }

    public int hashCode() {
        int result = this.hitNumber ^ this.hitNumber >>> 32;
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.entryId.hashCode();
        result = 31 * result + (int)(this.sequenceLength ^ this.sequenceLength >>> 32);
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.alignments.hashCode();
        return result;
    }

    public String toString() {
        return "HitImpl{hitNumber=" + this.hitNumber + ", database='" + this.database + '\'' + ", entryId='" + this.entryId + '\'' + ", sequenceLength=" + this.sequenceLength + ", description='" + this.description + '\'' + ", alignments=" + this.alignments + '}';
    }
}

