/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.util.RetryException;
import uk.ac.ebi.uniprot.dataservice.util.RetryOperation;

public abstract class AbstractLazyHit<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLazyHit.class);
    private static final int RETRY_ATTEMPTS = 3;
    private static final int SECONDS_RETRY_WAIT = 1;
    private RetryOperation<T> retryOperation = new RetryOperation(3, 1);

    protected T getEntry(String entryId, ReadEntryService<T> readService) {
        assert (readService != null) : "The read service can not be null";
        assert (entryId != null) : "The entry identifier can not be null";
        try {
            return (T)this.retryOperation.run(() -> readService.getEntry(entryId));
        }
        catch (RetryException e) {
            logger.warn("Unable to retrieve entry: {}, from UniParc search service. Retry attempts {}", (Object)entryId, (Object)3);
            return null;
        }
    }

    protected static interface ReadEntryService<T> {
        public T getEntry(String var1) throws ServiceException;
    }
}

