/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.main;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.CommaParameterSplitter;
import com.google.common.base.Strings;
import java.util.List;
import uk.ac.ebi.kraken.xml.uniprot.main.UniProtXmlConfigure;

public class UniProtXmlConfigureImpl
implements UniProtXmlConfigure {
    @Parameter(names={"-if"}, splitter=CommaParameterSplitter.class, description="input flat file (s), comma separated")
    private List<String> inputFiles;
    @Parameter(names={"-of"}, description="output xml file")
    private String outputFile;
    @Parameter(names={"-hdf"}, description="UniProt human disease file, humdisease.txt")
    private String humdiseaseFile;
    @Parameter(names={"-kwf"}, description="UniProt keyword file, keywlist.txt")
    private String keywordFile;
    @Parameter(names={"-n"}, description="number of threads, default size is 8")
    private int nthreads = 8;
    @Parameter(names={"-nohf"}, description="not include Xml header and footer")
    private boolean noIncludeHeaderFooter;
    @Parameter(names={"-kmf"}, description="keep intermediate xml files")
    private boolean keepIntermediate;
    @Parameter(names={"-imf"}, description="intermediate xml file prefix, default is: uniprot")
    private String intermFile = "uniprot";
    @Parameter(names={"-mr"}, description="metrics report interval in seconds")
    private int interval = 300;
    private JCommander jCommander;

    private UniProtXmlConfigureImpl() {
    }

    public static final UniProtXmlConfigure fromCommandLine(String[] args) {
        UniProtXmlConfigureImpl configurator = new UniProtXmlConfigureImpl();
        configurator.jCommander = new JCommander((Object)configurator, args);
        return configurator;
    }

    @Override
    public boolean isValid() {
        return this.inputFiles != null && !this.inputFiles.isEmpty() && !Strings.isNullOrEmpty((String)this.outputFile) && !Strings.isNullOrEmpty((String)this.humdiseaseFile) && !Strings.isNullOrEmpty((String)this.keywordFile);
    }

    @Override
    public String getUsage() {
        StringBuilder out = new StringBuilder();
        this.jCommander.usage(out);
        return out.toString();
    }

    @Override
    public String getHumdiseaseFilePath() {
        return this.humdiseaseFile;
    }

    @Override
    public String getKeywordFilePath() {
        return this.keywordFile;
    }

    @Override
    public int nThreads() {
        return this.nthreads;
    }

    @Override
    public boolean includeHeaderFooder() {
        return !this.noIncludeHeaderFooter;
    }

    @Override
    public List<String> getUniProtInputFFilePath() {
        return this.inputFiles;
    }

    @Override
    public String getUniProtXmlOutputFilePath() {
        return this.outputFile;
    }

    @Override
    public int metricsReportInterval() {
        return this.interval;
    }

    @Override
    public boolean keepIntermFiles() {
        return this.keepIntermediate;
    }

    @Override
    public String getIntermFilePrefix() {
        return this.intermFile;
    }
}

