/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.main;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.xml.exception.UniProtXmlException;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.Entry;
import uk.ac.ebi.kraken.xml.uniprot.UniProtEntryHandler;
import uk.ac.ebi.uniprot.parser.UniprotLineParser;
import uk.ac.ebi.uniprot.parser.impl.DefaultUniprotLineParserFactory;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObjectConverter;

public class UniProtFFToXmlConverter
implements Function<String, Entry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniProtFFToXmlConverter.class);
    private final UniprotLineParser<EntryObject> entryParser;
    private final EntryObjectConverter entryObjectConverter;
    private final UniProtEntryHandler uniProtEntryHandler;

    public UniProtFFToXmlConverter(String humdiseaseFilePath, String keywordFilePath) {
        DefaultUniprotLineParserFactory defaultUniprotLineParserFactory = new DefaultUniprotLineParserFactory();
        this.entryParser = defaultUniprotLineParserFactory.createEntryParser();
        this.entryObjectConverter = new EntryObjectConverter();
        this.uniProtEntryHandler = this.initUniProtHandler(humdiseaseFilePath, keywordFilePath);
    }

    @Override
    public Entry apply(String from) {
        EntryObject entry = null;
        UniProtEntry uniProtEntry = null;
        try {
            entry = this.entryParser.parse(from);
        }
        catch (Exception e) {
            String message = "Failed to parse flatfile entry";
            LOGGER.error(message, (Throwable)e);
            throw new UniProtXmlException(message, e);
        }
        try {
            uniProtEntry = this.entryObjectConverter.convert(entry);
        }
        catch (Exception e) {
            String message = "Failed to convert UniProtEntry: " + entry.ac.primaryAcc;
            LOGGER.warn(message);
            throw new UniProtXmlException(message, e);
        }
        try {
            return this.uniProtEntryHandler.toXmlBinding(uniProtEntry);
        }
        catch (Exception e) {
            String message = "Failed to convert xml entry: " + entry.ac.primaryAcc;
            LOGGER.warn(message);
            throw new UniProtXmlException(message, e);
        }
    }

    private UniProtEntryHandler initUniProtHandler(String humdiseaseFilePath, String keywordFilePath) {
        return UniProtEntryHandler.createNewInstance(humdiseaseFilePath, keywordFilePath, null);
    }
}

