/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.feature;

import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.FeatureType;
import uk.ac.ebi.kraken.xml.uniprot.feature.AltSequenceHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.FeatureHandlerStrategy;
import uk.ac.ebi.kraken.xml.uniprot.feature.LocationHandlerStrategy;

public class MutagenHandlerStrategy
implements FeatureHandlerStrategy<MutagenFeature> {
    private final AltSequenceHandlerStrategy altSequenceHandlerStrategy;
    private final LocationHandlerStrategy locationHandlerStrategy;

    public MutagenHandlerStrategy(AltSequenceHandlerStrategy altSequenceHandlerStrategy, LocationHandlerStrategy locationHandlerStrategy) {
        this.locationHandlerStrategy = locationHandlerStrategy;
        this.altSequenceHandlerStrategy = altSequenceHandlerStrategy;
    }

    @Override
    public void featureFromXmlBinding(MutagenFeature feature, FeatureType xmlFeature) {
        this.mutagenFromXmlBinding(feature, xmlFeature);
    }

    private void mutagenFromXmlBinding(MutagenFeature mutagenFeature, FeatureType xmlFeature) {
        this.locationHandlerStrategy.featureFromXmlBinding(mutagenFeature, xmlFeature);
        this.altSequenceHandlerStrategy.featureFromXmlBinding(mutagenFeature, xmlFeature);
        String description = xmlFeature.getDescription();
        if (description != null) {
            if (description.endsWith(".")) {
                description = description.substring(0, description.length() - 1).trim();
            }
            mutagenFeature.setMutagenReport(DefaultFeatureFactory.getInstance().buildMutagenReport(description));
        }
    }

    @Override
    public void featureToXmlBinding(MutagenFeature feature, FeatureType xmlFeature) {
        this.mutagenToXmlBinding(feature, xmlFeature);
    }

    private void mutagenToXmlBinding(MutagenFeature mutagenFeature, FeatureType xmlFeature) {
        this.altSequenceHandlerStrategy.featureToXmlBinding(mutagenFeature, xmlFeature);
        this.locationHandlerStrategy.featureToXmlBinding(mutagenFeature, xmlFeature);
        String report = mutagenFeature.getMutagenReport().getValue();
        if (report != null && !report.isEmpty()) {
            if (!report.endsWith(".")) {
                report = report + ".";
            }
            xmlFeature.setDescription(report);
        }
    }
}

