/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericXmlName;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class RecommendedNameHandler
extends GenericNameHandler<ProteinType.RecommendedName, Name> {
    public RecommendedNameHandler(ObjectFactory objectFactory, UniProtFactory factory, EvidenceReferenceHandler evidenceReferenceHandler, EcNumberHandler ecHandler) {
        super(objectFactory, factory, evidenceReferenceHandler, ecHandler);
    }

    @Override
    public ProteinType.RecommendedName toXmlName(Name name) {
        GenericXmlName xmlName = this.populateXmlName(name);
        return this.convertGenericToRecommendedName(xmlName);
    }

    @Override
    public Name fromXmlName(ProteinType.RecommendedName recXmlName) {
        GenericXmlName xmlName = this.convertRecommendedToGenericName(recXmlName);
        if (xmlName != null) {
            Name recName = this.populateName(xmlName);
            recName.setNameType(NameType.RECNAME);
            return recName;
        }
        return null;
    }

    private ProteinType.RecommendedName convertGenericToRecommendedName(GenericXmlName xmlName) {
        if (xmlName != null) {
            List<EvidencedStringType> ecNumberList;
            List<EvidencedStringType> shortNameList;
            boolean touched = false;
            ProteinType.RecommendedName recName = this.objectFactory.createProteinTypeRecommendedName();
            EvidencedStringType fullName = xmlName.getFullName();
            if (fullName != null) {
                recName.setFullName(fullName);
                touched = true;
            }
            if (!(shortNameList = xmlName.getShortNameList()).isEmpty()) {
                recName.getShortName().addAll(shortNameList);
                touched = true;
            }
            if (!(ecNumberList = xmlName.getEcNumberList()).isEmpty()) {
                recName.getEcNumber().addAll(ecNumberList);
                touched = true;
            }
            return touched ? recName : null;
        }
        return null;
    }

    private GenericXmlName convertRecommendedToGenericName(ProteinType.RecommendedName recXmlName) {
        if (recXmlName != null) {
            List<EvidencedStringType> ecNumberList;
            List<EvidencedStringType> shortNameList;
            boolean touched = false;
            GenericXmlName genericXmlName = new GenericXmlName();
            EvidencedStringType fullName = recXmlName.getFullName();
            if (fullName != null) {
                genericXmlName.setFullName(fullName);
                touched = true;
            }
            if (!(shortNameList = recXmlName.getShortName()).isEmpty()) {
                genericXmlName.setShortNameList(shortNameList);
                touched = true;
            }
            if (!(ecNumberList = recXmlName.getEcNumber()).isEmpty()) {
                genericXmlName.setEcNumberList(ecNumberList);
                touched = true;
            }
            return touched ? genericXmlName : null;
        }
        return null;
    }
}

