/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;

public abstract class GenericSectionHandler<T> {
    final ObjectFactory objectFactory;
    private final UniProtFactory factory;
    private final Map<NameType, GenericNameHandler> nameHandlerMap;

    GenericSectionHandler(ObjectFactory objectFactory, UniProtFactory factory, Map<NameType, GenericNameHandler> nameHandlerMap) {
        this.objectFactory = objectFactory;
        this.factory = factory;
        this.nameHandlerMap = nameHandlerMap;
    }

    public abstract T toXmlSection(Section var1);

    public abstract Section fromXmlSection(T var1);

    ProteinType populateProteinType(Section section) {
        if (section != null) {
            boolean boolResult;
            boolean touched = false;
            ProteinType xmlProtein = this.objectFactory.createProteinType();
            List<Name> recNameList = section.getNamesByType(NameType.RECNAME);
            if (recNameList != null && recNameList.size() == 1) {
                touched = this.toXmlRecName(recNameList.get(0), xmlProtein);
            }
            if (boolResult = this.toXmlAltName(section, xmlProtein)) {
                touched = true;
            }
            for (Name subName : section.getNamesByType(NameType.SUBNAME)) {
                boolResult = this.toXmlSubName(subName, xmlProtein);
                if (!boolResult) continue;
                touched = true;
            }
            return touched ? xmlProtein : null;
        }
        return null;
    }

    Section populateSection(ProteinType proteinType) {
        if (proteinType != null) {
            Section section = this.factory.buildSection();
            ProteinType.RecommendedName xmlRecName = proteinType.getRecommendedName();
            boolean touched = this.fromXmlRecName(xmlRecName, section);
            boolean boolResult = this.fromXmlAltName(proteinType, section);
            if (boolResult) {
                touched = true;
            }
            for (ProteinType.SubmittedName xmlSubName : proteinType.getSubmittedName()) {
                boolResult = this.fromXmlSubName(xmlSubName, section);
                if (!boolResult) continue;
                touched = true;
            }
            if (touched) {
                return section;
            }
        }
        return null;
    }

    private boolean toXmlRecName(Name name, ProteinType xmlProtein) {
        GenericNameHandler recommendedNameHandler = this.nameHandlerMap.get((Object)NameType.RECNAME);
        ProteinType.RecommendedName xmlName = (ProteinType.RecommendedName)recommendedNameHandler.toXmlName(name);
        if (xmlName != null) {
            xmlProtein.setRecommendedName(xmlName);
            return true;
        }
        return false;
    }

    private boolean fromXmlRecName(ProteinType.RecommendedName xmlRecName, Section section) {
        GenericNameHandler recommendedNameHandler = this.nameHandlerMap.get((Object)NameType.RECNAME);
        Name recName = (Name)recommendedNameHandler.fromXmlName(xmlRecName);
        if (recName != null) {
            section.getNames().add(recName);
            return true;
        }
        return false;
    }

    private boolean toXmlAltName(Section section, ProteinType xmlProtein) {
        if (section != null) {
            boolean touched = false;
            GenericNameHandler alternativeNameHandler = this.nameHandlerMap.get((Object)NameType.ALTNAME);
            ProteinType tempProteinType = (ProteinType)alternativeNameHandler.toXmlName(section);
            if (tempProteinType != null) {
                List<EvidencedStringType> innNameList;
                List<EvidencedStringType> antigeneNameList;
                EvidencedStringType biotechName;
                EvidencedStringType allergenName;
                List<ProteinType.AlternativeName> alternativeNameList = tempProteinType.getAlternativeName();
                if (!alternativeNameList.isEmpty()) {
                    xmlProtein.getAlternativeName().addAll(tempProteinType.getAlternativeName());
                    touched = true;
                }
                if ((allergenName = tempProteinType.getAllergenName()) != null) {
                    xmlProtein.setAllergenName(allergenName);
                    touched = true;
                }
                if ((biotechName = tempProteinType.getBiotechName()) != null) {
                    xmlProtein.setBiotechName(biotechName);
                    touched = true;
                }
                if (!(antigeneNameList = tempProteinType.getCdAntigenName()).isEmpty()) {
                    xmlProtein.getCdAntigenName().addAll(antigeneNameList);
                    touched = true;
                }
                if (!(innNameList = tempProteinType.getInnName()).isEmpty()) {
                    xmlProtein.getInnName().addAll(innNameList);
                    touched = true;
                }
            }
            return touched;
        }
        return false;
    }

    private boolean fromXmlAltName(ProteinType xmlProtein, Section section) {
        GenericNameHandler alternativeNameHandler;
        Section tempSection;
        if (xmlProtein != null && (tempSection = (Section)(alternativeNameHandler = this.nameHandlerMap.get((Object)NameType.ALTNAME)).fromXmlName(xmlProtein)) != null) {
            section.getNames().addAll(tempSection.getNamesByType(NameType.ALTNAME));
            return true;
        }
        return false;
    }

    private boolean toXmlSubName(Name name, ProteinType xmlProtein) {
        GenericNameHandler submittedNameHandler = this.nameHandlerMap.get((Object)NameType.SUBNAME);
        ProteinType.SubmittedName xmlSubName = (ProteinType.SubmittedName)submittedNameHandler.toXmlName(name);
        if (xmlSubName != null) {
            xmlProtein.getSubmittedName().add(xmlSubName);
            return true;
        }
        return false;
    }

    private boolean fromXmlSubName(ProteinType.SubmittedName submittedName, Section section) {
        GenericNameHandler submittedNameHandler = this.nameHandlerMap.get((Object)NameType.SUBNAME);
        Name subName = (Name)submittedNameHandler.fromXmlName(submittedName);
        if (subName != null) {
            section.getNames().add(subName);
            return true;
        }
        return false;
    }
}

