/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.regex.Pattern;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;

public class SequenceCautionConflictHandler
implements GenericHandler<String, CommentType.Conflict> {
    private static final Pattern TARGET_A = Pattern.compile("[A-Z]{1}\\d{5}");
    private static final Pattern TARGET_B = Pattern.compile("[A-Z]{4}\\d{8,9}");
    private static final Pattern TARGET_C = Pattern.compile("[A-Z]{2}\\d{6}");
    private static final Pattern TARGET_D = Pattern.compile("[A-Z]{3}\\d{5}\\.\\d");
    private static final Pattern TARGET_E = Pattern.compile("Ref\\.\\d+");
    private final ObjectFactory objectFactory;

    public SequenceCautionConflictHandler(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public String fromXmlBinding(CommentType.Conflict conflict) {
        if (conflict != null && conflict.getSequence() != null) {
            CommentType.Conflict.Sequence sequenceType = conflict.getSequence();
            String sequence = sequenceType.getResource().equals("EMBL") ? sequenceType.getId() : (sequenceType.getResource().equals("EMBL-CDS") ? sequenceType.getId() + "." + sequenceType.getVersion().toString() : "Ref." + conflict.getRef());
            return sequence;
        }
        if (conflict != null && conflict.getSequence() == null && conflict.getRef() != null) {
            String sequence = "Ref." + conflict.getRef();
            return sequence;
        }
        return null;
    }

    @Override
    public CommentType.Conflict toXmlBinding(String sequenceId) {
        if (sequenceId != null && !sequenceId.trim().isEmpty()) {
            CommentType.Conflict conflict = this.objectFactory.createCommentTypeConflict();
            CommentType.Conflict.Sequence sequence = this.objectFactory.createCommentTypeConflictSequence();
            if (TARGET_A.matcher(sequenceId).matches() || TARGET_B.matcher(sequenceId).matches() || TARGET_C.matcher(sequenceId).matches()) {
                sequence.setId(sequenceId);
                sequence.setResource("EMBL");
                conflict.setSequence(sequence);
            } else if (TARGET_D.matcher(sequenceId).matches()) {
                sequence.setId(sequenceId.substring(0, sequenceId.indexOf(46)));
                sequence.setResource("EMBL-CDS");
                String version = sequenceId.substring(sequenceId.indexOf(46) + 1);
                sequence.setVersion(new Integer(version));
                conflict.setSequence(sequence);
            } else if (TARGET_E.matcher(sequenceId).matches()) {
                String ref = sequenceId.substring(sequenceId.indexOf(46) + 1, sequenceId.length());
                conflict.setRef(ref);
                conflict.setSequence(null);
            }
            return conflict;
        }
        return null;
    }
}

