/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.parser.CommentHelper;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class KineticParametersHandler
implements GenericHandler<KineticParameters, CommentType.Kinetics> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final EvidencedValueHandler evidencedValueHandler;

    public KineticParametersHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = referenceHandler;
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, referenceHandler);
    }

    @Override
    public KineticParameters fromXmlBinding(CommentType.Kinetics kineticsXML) {
        KineticParameters kineticParams = this.commentFactory.buildKineticParameters();
        if (kineticsXML != null) {
            for (EvidencedStringType kmXML : kineticsXML.getKM()) {
                MichaelisConstant michaelisConstant = this.commentFactory.buildMichaelisConstant();
                CommentHelper.parseMichaelisConstant(kmXML.getValue(), michaelisConstant);
                if (!kmXML.getEvidence().isEmpty()) {
                    michaelisConstant.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(kmXML.getEvidence()));
                }
                kineticParams.getMichaelisConstants().add(michaelisConstant);
            }
            for (EvidencedStringType vmax : kineticsXML.getVmax()) {
                MaximumVelocity maxVelocity = this.commentFactory.buildMaximumVelocity();
                CommentHelper.parseMaximumVelocity(vmax.getValue(), maxVelocity);
                if (!vmax.getEvidence().isEmpty()) {
                    maxVelocity.getEvidenceIds().addAll(this.evidenceReferenceHandler.parseEvidenceIDs(vmax.getEvidence()));
                }
                kineticParams.getMaximumVelocities().add(maxVelocity);
            }
            if (!kineticsXML.getText().isEmpty()) {
                KineticParameterNote note = this.commentFactory.buildKineticParameterNote();
                ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
                for (EvidencedStringType evStr : kineticsXML.getText()) {
                    evValues.add(this.evidencedValueHandler.fromXmlBinding(evStr));
                }
                note.setTexts(evValues);
                kineticParams.setNote(note);
            }
            return kineticParams;
        }
        return null;
    }

    @Override
    public CommentType.Kinetics toXmlBinding(KineticParameters kineticParams) {
        if (kineticParams != null) {
            CommentType.Kinetics kineticsXML = this.objectFactory.createCommentTypeKinetics();
            for (MichaelisConstant michaelisConstant : kineticParams.getMichaelisConstants()) {
                EvidencedStringType kmkinetics = this.objectFactory.createEvidencedStringType();
                kmkinetics.setValue(CommentHelper.createXMLStringMichaelisConstant(michaelisConstant));
                if (!michaelisConstant.getEvidenceIds().isEmpty()) {
                    kmkinetics.getEvidence().addAll(this.evidenceReferenceHandler.writeEvidenceIDs(michaelisConstant.getEvidenceIds()));
                }
                kineticsXML.getKM().add(kmkinetics);
            }
            for (MaximumVelocity maximumVelocity : kineticParams.getMaximumVelocities()) {
                EvidencedStringType vmaxKinetics = this.objectFactory.createEvidencedStringType();
                vmaxKinetics.setValue(CommentHelper.createXMLStringMaximumVelocity(maximumVelocity));
                if (!maximumVelocity.getEvidenceIds().isEmpty()) {
                    vmaxKinetics.getEvidence().addAll(this.evidenceReferenceHandler.writeEvidenceIDs(maximumVelocity.getEvidenceIds()));
                }
                kineticsXML.getVmax().add(vmaxKinetics);
            }
            if (kineticParams.hasKineticParameterNote()) {
                for (EvidencedValue evValue : kineticParams.getNote().getTexts()) {
                    EvidencedStringType textAbsorption = this.evidencedValueHandler.toXmlBinding(evValue);
                    kineticsXML.getText().add(textAbsorption);
                }
            }
            return kineticsXML;
        }
        return null;
    }
}

