/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.thread.Consumer;
import uk.ac.ebi.kraken.util.thread.FutureDescription;
import uk.ac.ebi.kraken.util.thread.ResultHandler;
import uk.ac.ebi.kraken.util.thread.SimpleThreadFactory;

public class ThreadService<T> {
    public static final String LoggerName = "uk.ac.ebi.kraken.util.mt";
    private final BlockingQueue<FutureDescription<T>> queue;
    private final ExecutorService service;
    private final Consumer<T> consumer;
    private boolean started;
    private final Logger mtLogger = LoggerFactory.getLogger((String)"uk.ac.ebi.kraken.util.mt");

    public ThreadService(int queuesize, int threadpoolsize, int reportInterval, ResultHandler<T> consumer) {
        this.queue = new LinkedBlockingQueue<FutureDescription<T>>(queuesize);
        this.service = Executors.newFixedThreadPool(threadpoolsize, new SimpleThreadFactory());
        this.consumer = new Consumer<T>(this.queue, consumer, reportInterval);
    }

    public void setConsumerName(String name) {
        this.consumer.setName(name);
    }

    public void start() {
        if (this.started) {
            this.mtLogger.warn("Threading service has already started.");
            throw new IllegalStateException("The service has already started.");
        }
        this.mtLogger.info("Threading service to be started.");
        this.consumer.start();
        this.started = true;
    }

    public void process(Callable<T> task) {
        if (this.started) {
            Future<T> submit = this.service.submit(task);
            FutureDescription<T> futureDescription = new FutureDescription<T>(submit, task.toString());
            try {
                this.queue.put(futureDescription);
                this.mtLogger.debug("Task has been submitted to the threading service: " + task.toString());
            }
            catch (InterruptedException e) {
                this.mtLogger.warn("the main processing thread is interrupted.");
            }
        } else {
            this.mtLogger.warn("Threading service has not been started yet.");
            throw new IllegalStateException("The service has not been started yet.");
        }
    }

    public void shutdown() {
        if (this.started) {
            this.mtLogger.debug("Threading service to be shutdown.");
            this.service.shutdown();
            while (!this.service.isTerminated()) {
                try {
                    this.mtLogger.debug("Wait for the existed tasks to be finished.");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.mtLogger.warn("Threading service has not been started yet.");
            throw new IllegalStateException("The service has not been started yet.");
        }
        this.consumer.interrupt();
        this.mtLogger.info("Threading service is shutdown.");
    }
}

