/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.thread;

import java.text.AttributedCharacterIterator;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SimpleDateFormatThreadSafe
extends SimpleDateFormat {
    private static final long serialVersionUID = 5448371898056188202L;
    ThreadLocal<SimpleDateFormat> localSimpleDateFormat;

    public SimpleDateFormatThreadSafe() {
        this.localSimpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat();
            }
        };
    }

    public SimpleDateFormatThreadSafe(final String pattern) {
        super(pattern);
        this.localSimpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(pattern);
            }
        };
    }

    public SimpleDateFormatThreadSafe(final String pattern, final DateFormatSymbols formatSymbols) {
        super(pattern, formatSymbols);
        this.localSimpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(pattern, formatSymbols);
            }
        };
    }

    public SimpleDateFormatThreadSafe(final String pattern, final Locale locale) {
        super(pattern, locale);
        this.localSimpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(pattern, locale);
            }
        };
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.localSimpleDateFormat.get().parseObject(source);
    }

    public String toString() {
        return this.localSimpleDateFormat.get().toString();
    }

    @Override
    public Date parse(String source) throws ParseException {
        return this.localSimpleDateFormat.get().parse(source);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.localSimpleDateFormat.get().parseObject(source, pos);
    }

    @Override
    public void setCalendar(Calendar newCalendar) {
        this.localSimpleDateFormat.get().setCalendar(newCalendar);
    }

    @Override
    public Calendar getCalendar() {
        return this.localSimpleDateFormat.get().getCalendar();
    }

    @Override
    public void setNumberFormat(NumberFormat newNumberFormat) {
        this.localSimpleDateFormat.get().setNumberFormat(newNumberFormat);
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.localSimpleDateFormat.get().getNumberFormat();
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        this.localSimpleDateFormat.get().setTimeZone(zone);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.localSimpleDateFormat.get().getTimeZone();
    }

    @Override
    public void setLenient(boolean lenient) {
        this.localSimpleDateFormat.get().setLenient(lenient);
    }

    @Override
    public boolean isLenient() {
        return this.localSimpleDateFormat.get().isLenient();
    }

    @Override
    public void set2DigitYearStart(Date startDate) {
        this.localSimpleDateFormat.get().set2DigitYearStart(startDate);
    }

    @Override
    public Date get2DigitYearStart() {
        return this.localSimpleDateFormat.get().get2DigitYearStart();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.localSimpleDateFormat.get().format(date, toAppendTo, pos);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        return this.localSimpleDateFormat.get().formatToCharacterIterator(obj);
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        return this.localSimpleDateFormat.get().parse(text, pos);
    }

    @Override
    public String toPattern() {
        return this.localSimpleDateFormat.get().toPattern();
    }

    @Override
    public String toLocalizedPattern() {
        return this.localSimpleDateFormat.get().toLocalizedPattern();
    }

    @Override
    public void applyPattern(String pattern) {
        this.localSimpleDateFormat.get().applyPattern(pattern);
    }

    @Override
    public void applyLocalizedPattern(String pattern) {
        this.localSimpleDateFormat.get().applyLocalizedPattern(pattern);
    }

    @Override
    public DateFormatSymbols getDateFormatSymbols() {
        return this.localSimpleDateFormat.get().getDateFormatSymbols();
    }

    @Override
    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        this.localSimpleDateFormat.get().setDateFormatSymbols(newFormatSymbols);
    }

    @Override
    public Object clone() {
        return this.localSimpleDateFormat.get().clone();
    }

    @Override
    public int hashCode() {
        return this.localSimpleDateFormat.get().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.localSimpleDateFormat.get().equals(obj);
    }
}

