/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMerger {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileMerger.class);
    private final String header;
    private final String footer;
    private final int bufferSize;

    public FileMerger() {
        this("", "", 4096);
    }

    public FileMerger(String header, String footer) {
        this(header, footer, 4096);
    }

    public FileMerger(String header, String footer, int bufferSize) {
        this.header = header;
        this.footer = footer;
        this.bufferSize = bufferSize;
    }

    public void merge(String outputFile, List<String> inputFiles) throws IOException {
        LOGGER.info("merge file to: {}", (Object)outputFile);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outputFile), true));){
            if (this.header != null && !this.header.isEmpty()) {
                ByteArrayInputStream headerStream = new ByteArrayInputStream(this.header.getBytes());
                IOUtils.copy((InputStream)headerStream, (OutputStream)out, (int)this.bufferSize);
            }
            for (String inputFile : inputFiles) {
                LOGGER.info("merge file from: {}", (Object)inputFile);
                try {
                    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(inputFile)));
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)out, (int)this.bufferSize);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
                catch (FileNotFoundException ex) {
                    LOGGER.error("File {} does not exist", (Throwable)ex);
                }
            }
            if (this.footer != null && !this.footer.isEmpty()) {
                ByteArrayInputStream footerStream = new ByteArrayInputStream(this.footer.getBytes());
                IOUtils.copy((InputStream)footerStream, (OutputStream)out, (int)this.bufferSize);
            }
        }
    }
}

