/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.math.BigDecimal;

public class Crc64 {
    private static long[] crc64Array = new long[256];

    private Crc64() {
    }

    public static long getCrc64Long(String sequence) {
        long pOLY64Reverse = -2882303761517117440L;
        long reminder = 0L;
        for (int i = 0; i < sequence.length(); ++i) {
            reminder ^= (long)sequence.charAt(i);
            for (int bit = 7; bit >= 0; --bit) {
                if ((reminder & 1L) == 1L) {
                    reminder = reminder >>> 1 ^ pOLY64Reverse;
                    continue;
                }
                reminder >>>= 1;
            }
        }
        return reminder;
    }

    public static BigDecimal getCrc64BD(String sequence) {
        Long val = Crc64.getCrc64Long(sequence);
        if (val > 0L) {
            return BigDecimal.valueOf(val);
        }
        BigDecimal bd = BigDecimal.valueOf(val);
        bd = bd.add(BigDecimal.valueOf(Long.MAX_VALUE));
        bd = bd.add(BigDecimal.valueOf(Long.MAX_VALUE));
        bd = bd.add(BigDecimal.valueOf(2L));
        return bd;
    }

    public static String getCrc64(String sequence) {
        long crc64Number = 0L;
        for (int i = 0; i < sequence.length(); ++i) {
            char symbol = sequence.charAt(i);
            long a = crc64Number >>> 8;
            long b = (crc64Number ^ (long)symbol) & 0xFFL;
            crc64Number = a ^ crc64Array[(int)b];
        }
        String crc64String = Long.toHexString(crc64Number).toUpperCase();
        StringBuilder crc64 = new StringBuilder("0000000000000000");
        crc64.replace(crc64.length() - crc64String.length(), crc64.length(), crc64String);
        return crc64.toString();
    }

    static {
        for (int i = 0; i <= 255; ++i) {
            long k = i;
            for (int j = 0; j < 8; ++j) {
                if ((k & 1L) != 0L) {
                    k = k >>> 1 ^ 0xD800000000000000L;
                    continue;
                }
                k >>>= 1;
            }
            Crc64.crc64Array[i] = k;
        }
    }
}

