/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.HasCommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.parser.translator.AlternativeProductsCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.BioPhysioChemPropertyCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CatalyticActivityCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CofactorCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.DiseaseCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.InteractionCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.MassSpectrometryCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.RnaEditingCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.SequenceCautionCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.SubcellularLocationCommentTranslater;
import uk.ac.ebi.kraken.parser.translator.TextOnlyCommentTranslator;
import uk.ac.ebi.kraken.parser.translator.WebResourceCommentTranslator;

public class CommentTranslatorHelper {
    private static final CommentTranslator<TextOnlyComment> DEAFULT_BUILDER = new TextOnlyCommentTranslator();
    private static Map<CommentType, CommentTranslator<? extends Comment>> commentTranslator = new EnumMap<CommentType, CommentTranslator<? extends Comment>>(CommentType.class);

    public static <T extends Comment> CommentTranslator<T> createTranslator(T f) {
        CommentTranslator<? extends Comment> builder = commentTranslator.get((Object)f.getCommentType());
        if (builder != null) {
            return builder;
        }
        return DEAFULT_BUILDER;
    }

    public static String trimCommentHeader(String annotation, CommentType type) {
        if (annotation.startsWith(type.toDisplayName()) && (annotation = annotation.substring(type.toDisplayName().length() + 1).trim()).startsWith("\n")) {
            annotation = annotation.substring(1);
        }
        return annotation;
    }

    public static <T extends Comment> T translate(String annotation, CommentType type) {
        Object comment = DefaultCommentFactory.getInstance().buildComment(type);
        CommentTranslator translator = CommentTranslatorHelper.createTranslator(comment);
        translator.translate(annotation, comment);
        return comment;
    }

    public static String stripTrailing(String val, String trail) {
        if (val.endsWith(trail)) {
            return val.substring(0, val.length() - trail.length());
        }
        return val;
    }

    public static String stripEvidenceIds(String line, List<EvidenceId> evidences) {
        if (line.endsWith("}") || line.endsWith("};") || line.endsWith("}.")) {
            String ev = line.substring(line.lastIndexOf(123) + 1, line.lastIndexOf(125));
            StringTokenizer st = new StringTokenizer(ev, ",");
            while (st.hasMoreTokens()) {
                evidences.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(st.nextToken().trim()));
            }
        } else {
            return line;
        }
        return line.substring(0, line.lastIndexOf(123)).trim();
    }

    public static List<EvidencedValue> parseEvidencedValues(String value, boolean trimEndFullStop) {
        return CommentTranslatorHelper.parseEvidencedValues(value, trimEndFullStop, '.');
    }

    public static List<EvidencedValue> parseEvidencedValues(String value, boolean trimEndFullStop, char separator) {
        int index;
        ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
        char comm = separator;
        char curing = '}';
        char dot = '.';
        String temp = value;
        if (temp.endsWith(";")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        if ((index = temp.indexOf(comm)) == -1 || index == value.length() - 1) {
            evValues.add(CommentTranslatorHelper.parseEvidencedValue(temp, trimEndFullStop));
            return evValues;
        }
        do {
            if (temp.charAt(index - 1) == curing || temp.charAt(index - 1) == dot) {
                String token = temp.substring(0, index).trim();
                evValues.add(CommentTranslatorHelper.parseEvidencedValue(token, trimEndFullStop));
                temp = temp.substring(index + 1).trim();
                index = temp.indexOf(comm);
                continue;
            }
            index = temp.indexOf(comm, index + 1);
        } while (index != -1 && index != temp.length() - 1);
        if (!temp.isEmpty()) {
            evValues.add(CommentTranslatorHelper.parseEvidencedValue(temp, trimEndFullStop));
        }
        return evValues;
    }

    public static EvidencedValue parseEvidencedValue(String value, boolean trimEndFullStop) {
        EvidencedValue evValue = DefaultUniProtFactory.getInstance().buildEvidencedValue();
        ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
        String val = value;
        if (val.endsWith(";")) {
            val = val.substring(0, val.length() - 1);
        }
        val = CommentTranslatorHelper.stripEvidenceIds(val, evidences);
        if (trimEndFullStop && val.endsWith(".")) {
            val = val.substring(0, val.length() - 1).trim();
        }
        evValue.setValue(val);
        evValue.setEvidenceIds(evidences);
        return evValue;
    }

    public static String setCommentStatus(String annotation, HasCommentStatus comment) {
        if (annotation.endsWith(" (Potential)") || annotation.endsWith("(Potential)") || annotation.endsWith(" (potential)")) {
            comment.setCommentStatus(CommentStatus.POTENTIAL);
            annotation = annotation.substring(0, annotation.length() - 11).trim();
        } else if (annotation.endsWith(" (Probable)") || annotation.endsWith("(Probable)") || annotation.endsWith(" (probable)")) {
            comment.setCommentStatus(CommentStatus.PROBABLE);
            annotation = annotation.substring(0, annotation.length() - 10).trim();
        } else if (annotation.endsWith(" (By similarity)") || annotation.endsWith("(By similarity)") || annotation.endsWith(" (By Similarity)") || annotation.endsWith(" (by similarity)")) {
            comment.setCommentStatus(CommentStatus.BY_SIMILARITY);
            annotation = annotation.substring(0, annotation.length() - 15).trim();
        } else {
            comment.setCommentStatus(CommentStatus.EXPERIMENTAL);
        }
        return annotation;
    }

    static {
        commentTranslator.put(CommentType.ALTERNATIVE_PRODUCTS, new AlternativeProductsCommentTranslator());
        commentTranslator.put(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES, new BioPhysioChemPropertyCommentTranslator());
        commentTranslator.put(CommentType.COFACTOR, new CofactorCommentTranslator());
        commentTranslator.put(CommentType.DISEASE, new DiseaseCommentTranslator());
        commentTranslator.put(CommentType.INTERACTION, new InteractionCommentTranslator());
        commentTranslator.put(CommentType.MASS_SPECTROMETRY, new MassSpectrometryCommentTranslator());
        commentTranslator.put(CommentType.RNA_EDITING, new RnaEditingCommentTranslator());
        commentTranslator.put(CommentType.SEQUENCE_CAUTION, new SequenceCautionCommentTranslator());
        commentTranslator.put(CommentType.SUBCELLULAR_LOCATION, new SubcellularLocationCommentTranslater());
        commentTranslator.put(CommentType.WEBRESOURCE, new WebResourceCommentTranslator());
        commentTranslator.put(CommentType.CATALYTIC_ACTIVITY, new CatalyticActivityCommentTranslator());
    }
}

