/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class BioPhysioChemPropertyCommentTranslator
implements CommentTranslator<BioPhysicoChemicalPropertiesComment> {
    private static final String VMAX = "Vmax=";
    private static final String NOTE2 = "Note=";
    private static final String ABS_MAX = "Abs(max)=";
    private static final String ABSORPTION = "Absorption:";
    private static final String REDOX_POTENTIAL = "Redox potential:";
    private static final String P_H_DEPENDENCE = "pH dependence:";
    private static final String TEMPERATURE_DEPENDENCE = "Temperature dependence:";
    private static final String KINETIC_PARAMETERS = "Kinetic parameters:";
    private static final String KM2 = "KM=";
    private static final CommentType COMMENT_TYPE = CommentType.BIOPHYSICOCHEMICAL_PROPERTIES;
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();

    @Override
    public BioPhysicoChemicalPropertiesComment translate(String annotation) {
        BioPhysicoChemicalPropertiesComment comment = (BioPhysicoChemicalPropertiesComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    @Override
    public void translate(String annotation, BioPhysicoChemicalPropertiesComment comment) {
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ".");
        annotation = this.updateMolecule(annotation, comment);
        StringTokenizer st = new StringTokenizer(annotation, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.switchTopic(token, st, comment);
        }
    }

    private String updateMolecule(String annotation, BioPhysicoChemicalPropertiesComment comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2);
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    private void switchTopic(String line, StringTokenizer lines, BioPhysicoChemicalPropertiesComment comment) {
        if (line.equals(KINETIC_PARAMETERS)) {
            List<String> tokens = this.getTypeLines(lines, comment);
            comment.setKineticParameters(this.buildKineticParameters(tokens));
        } else if (line.equals(TEMPERATURE_DEPENDENCE)) {
            List<String> tokens = this.getTypeLines(lines, comment);
            comment.setTemperatureDependence(this.buildTemperatureDependence(tokens));
        } else if (line.equals(P_H_DEPENDENCE)) {
            List<String> tokens = this.getTypeLines(lines, comment);
            comment.setPHDepencence(this.buildPHDependence(tokens));
        } else if (line.equals(REDOX_POTENTIAL)) {
            List<String> tokens = this.getTypeLines(lines, comment);
            comment.setRedoxPotential(this.buildRedoxPotential(tokens));
        } else if (line.equals(ABSORPTION)) {
            List<String> tokens = this.getTypeLines(lines, comment);
            comment.setAbsorption(this.buildAbsorption(tokens));
        } else {
            throw new RuntimeException(line + " is unknown");
        }
    }

    private List<String> getTypeLines(StringTokenizer lines, BioPhysicoChemicalPropertiesComment comment) {
        ArrayList<String> tokenlines = new ArrayList<String>();
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (!this.isLineTitle(line)) {
                tokenlines.add(line.trim());
                continue;
            }
            this.switchTopic(line, lines, comment);
        }
        return tokenlines;
    }

    private boolean isLineTitle(String line) {
        return line.equals(KINETIC_PARAMETERS) || line.equals(TEMPERATURE_DEPENDENCE) || line.equals(P_H_DEPENDENCE) || line.equals(REDOX_POTENTIAL) || line.equals(ABSORPTION);
    }

    public Absorption buildAbsorption(List<String> lines) {
        Absorption absorption = FACTORY.buildAbsorption();
        String absMaxLine = "";
        String noteLine = "";
        boolean noteLineStart = false;
        boolean absMaxLineStart = false;
        for (String line : lines) {
            if ((line = line.trim()).startsWith(ABS_MAX)) {
                absMaxLineStart = true;
                noteLineStart = false;
                absMaxLine = line;
                continue;
            }
            if (line.startsWith(NOTE2)) {
                absMaxLineStart = false;
                noteLineStart = true;
                noteLine = line;
                continue;
            }
            if (absMaxLineStart) {
                absMaxLine = absMaxLine + " ";
                absMaxLine = absMaxLine + line;
                continue;
            }
            if (!noteLineStart) continue;
            noteLine = noteLine + " ";
            noteLine = noteLine + line;
        }
        if (!Strings.isNullOrEmpty((String)absMaxLine)) {
            String unitSection = (absMaxLine = CommentTranslatorHelper.stripEvidenceIds(absMaxLine, absorption.getEvidenceIds())).substring(9, absMaxLine.length());
            String val = unitSection.substring(0, unitSection.indexOf(32));
            boolean startsWithTilde = val.startsWith("~");
            if (startsWithTilde) {
                absorption.setMax(Integer.parseInt(val.substring(1)));
            } else {
                absorption.setMax(Integer.parseInt(val));
            }
            absorption.setApproximation(startsWithTilde);
        }
        if (!Strings.isNullOrEmpty((String)noteLine)) {
            String comment = noteLine.substring(5, noteLine.length());
            AbsorptionNote note = FACTORY.buildAbsorptionNote();
            List<EvidencedValue> evValues = CommentTranslatorHelper.parseEvidencedValues(comment, false);
            note.setTexts(evValues);
            absorption.setNote(note);
        }
        return absorption;
    }

    public PHDependence buildPHDependence(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(" ");
        }
        PHDependence phDependence = FACTORY.buildPHDependence();
        phDependence.setTexts(CommentTranslatorHelper.parseEvidencedValues(sb.toString().trim(), false));
        return phDependence;
    }

    public RedoxPotential buildRedoxPotential(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(" ");
        }
        RedoxPotential redoxPotential = FACTORY.buildRedoxPotential();
        redoxPotential.setTexts(CommentTranslatorHelper.parseEvidencedValues(sb.toString().trim(), false));
        return redoxPotential;
    }

    public TemperatureDependence buildTemperatureDependence(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(" ");
        }
        TemperatureDependence tempDe = FACTORY.buildTemperatureDependence();
        tempDe.setTexts(CommentTranslatorHelper.parseEvidencedValues(sb.toString().trim(), false));
        return tempDe;
    }

    public MichaelisConstant buildMichaelisConstant(String line) {
        MichaelisConstant km = FACTORY.buildMichaelisConstant();
        if ((line = CommentTranslatorHelper.stripEvidenceIds(line, km.getEvidenceIds())).endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(line.substring(3), " ");
        String val = st.nextToken();
        val = val.replace(",", "");
        double value = Double.parseDouble(val);
        km.setConstantStr(val);
        String unit = st.nextToken();
        if (!st.nextToken().equals("for")) {
            throw new RuntimeException();
        }
        StringBuilder commentRestline = new StringBuilder();
        while (st.hasMoreTokens()) {
            commentRestline.append(st.nextToken());
            commentRestline.append(" ");
        }
        String commentStr = commentRestline.toString().trim();
        km.setConstant((float)value);
        km.setUnit(MichaelisConstantUnit.convert(unit));
        km.setSubstrate(FACTORY.buildSubstrate(commentStr));
        return km;
    }

    public MaximumVelocity buildMaximumVelocity(String line) {
        MaximumVelocity mv = FACTORY.buildMaximumVelocity();
        if ((line = CommentTranslatorHelper.stripEvidenceIds(line, mv.getEvidenceIds())).endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(line.substring(5), " ");
        String vel = st.nextToken();
        double value = Double.parseDouble(vel);
        mv.setVelocityStr(vel);
        String unit = st.nextToken();
        StringBuilder commentRestline = new StringBuilder();
        while (st.hasMoreTokens()) {
            commentRestline.append(st.nextToken());
            commentRestline.append(" ");
        }
        String commentStr = commentRestline.toString().trim();
        mv.setMaxVelocityUnit(FACTORY.buildMaxVelocityUnit(unit));
        mv.setVelocity((float)value);
        mv.setEnzyme(FACTORY.buildEnzyme(commentStr));
        return mv;
    }

    public KineticParameters buildKineticParameters(List<String> lines) {
        KineticParameters kp = FACTORY.buildKineticParameters();
        ArrayList<String> kms = new ArrayList<String>();
        boolean isKmLine = false;
        String currentkmLine = "";
        ArrayList<String> vms = new ArrayList<String>();
        boolean isvmsLine = false;
        String currentVmsLine = "";
        String noteLine = "";
        boolean noteLineStart = false;
        for (String line : lines) {
            if ((line = line.trim()).startsWith(KM2)) {
                if (!Strings.isNullOrEmpty((String)currentkmLine)) {
                    kms.add(currentkmLine);
                    currentkmLine = "";
                }
                isKmLine = true;
                isvmsLine = false;
                noteLineStart = false;
                currentkmLine = line;
                continue;
            }
            if (line.startsWith(VMAX)) {
                if (!Strings.isNullOrEmpty((String)currentVmsLine)) {
                    vms.add(currentVmsLine);
                    currentVmsLine = "";
                }
                isKmLine = false;
                isvmsLine = true;
                noteLineStart = false;
                currentVmsLine = line;
                continue;
            }
            if (line.startsWith(NOTE2)) {
                isKmLine = false;
                isvmsLine = false;
                noteLineStart = true;
                noteLine = line;
                continue;
            }
            if (isKmLine) {
                currentkmLine = currentkmLine + " ";
                currentkmLine = currentkmLine + line;
                continue;
            }
            if (isvmsLine) {
                currentVmsLine = currentVmsLine + " ";
                currentVmsLine = currentVmsLine + line;
                continue;
            }
            if (!noteLineStart) continue;
            noteLine = noteLine + " ";
            noteLine = noteLine + line;
        }
        if (!Strings.isNullOrEmpty((String)currentkmLine)) {
            kms.add(currentkmLine);
        }
        if (!Strings.isNullOrEmpty((String)currentVmsLine)) {
            vms.add(currentVmsLine);
        }
        for (String line : kms) {
            kp.getMichaelisConstants().add(this.buildMichaelisConstant(line));
        }
        for (String line : vms) {
            kp.getMaximumVelocities().add(this.buildMaximumVelocity(line));
        }
        if (!Strings.isNullOrEmpty((String)noteLine)) {
            String commentStr = noteLine.substring(5, noteLine.length());
            KineticParameterNote kpn = FACTORY.buildKineticParameterNote();
            kpn.setTexts(CommentTranslatorHelper.parseEvidencedValues(commentStr, false));
            kp.setNote(kpn);
        }
        return kp;
    }
}

