/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.keywordlist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordCategory;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;
import uk.ac.ebi.kraken.parser.keywordlist.KeywordLineType;

public class CategoryParser {
    private BufferedReader reader;

    private CategoryParser(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public static Map<String, KeywordCategory> buildCategoryMap(Reader reader) throws IOException {
        CategoryParser parser = new CategoryParser(reader);
        return parser.parse();
    }

    private Map<String, KeywordCategory> parse() throws IOException {
        this.initializeStream();
        HashMap<String, KeywordCategory> retVal = new HashMap<String, KeywordCategory>();
        DefaultKeywordListFactory kwListFactory = DefaultKeywordListFactory.getInstance();
        if (this.reader.ready()) {
            String line = null;
            StringBuilder deSB = null;
            KeywordCategory cat = null;
            line = this.reader.readLine();
            while (line != null) {
                String lineTypeString;
                if (line.length() > 4) {
                    lineTypeString = line.substring(0, 5);
                    if (line.endsWith(".")) {
                        line = line.substring(0, line.length() - 1);
                    }
                } else {
                    lineTypeString = line.length() > 1 ? line : line;
                }
                if (lineTypeString != null) {
                    switch (KeywordLineType.getType(lineTypeString.trim())) {
                        case AC: {
                            if (cat == null) break;
                            cat.setAccession(kwListFactory.buildAccession(line.substring(5)));
                            break;
                        }
                        case AN: {
                            break;
                        }
                        case CA: {
                            break;
                        }
                        case DE: {
                            if (deSB == null) break;
                            if (deSB.length() > 0) {
                                deSB.append('\n');
                            }
                            deSB.append(line.substring(5));
                            break;
                        }
                        case GO: {
                            break;
                        }
                        case HI: {
                            break;
                        }
                        case IC: {
                            cat = kwListFactory.buildCategory(line.substring(5));
                            deSB = new StringBuilder();
                            break;
                        }
                        case ID: {
                            break;
                        }
                        case RU: {
                            break;
                        }
                        case SY: {
                            break;
                        }
                        case TERM: {
                            if (cat == null) break;
                            cat.setDescription(kwListFactory.buildDescription(deSB.toString()));
                            retVal.put(cat.getIdentifier().getValue(), cat);
                            cat = null;
                            break;
                        }
                        case UNKNOWN: {
                            break;
                        }
                    }
                }
                line = this.reader.readLine();
            }
        }
        this.closeStream();
        return retVal;
    }

    private void closeStream() throws IOException {
        this.reader.close();
    }

    private void initializeStream() throws IOException {
        if (this.reader.ready()) {
            String line = null;
            while ((line = this.reader.readLine()) != null && !line.startsWith("_____")) {
            }
        }
    }
}

