/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.keywords;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class KeywordImpl
implements PersistentObject,
Keyword {
    private String value;
    private List<EvidenceId> evidenceIds;
    private long id;

    public KeywordImpl() {
        this.value = "";
    }

    public KeywordImpl(Keyword copy) {
        this.value = copy.getValue();
        this.evidenceIds = new NoNullElementsList<EvidenceId>(new ArrayList());
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        if (evidenceIds == null) {
            throw new IllegalArgumentException();
        }
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeywordImpl)) {
            return false;
        }
        KeywordImpl keyword1 = (KeywordImpl)o;
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? !this.evidenceIds.equals(keyword1.evidenceIds) : keyword1.evidenceIds != null && !keyword1.evidenceIds.isEmpty()) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(keyword1.value) : keyword1.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 29 * result + (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? this.evidenceIds.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.value);
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty()) {
            result.append("{");
            Iterator<EvidenceId> it = this.evidenceIds.iterator();
            while (it.hasNext()) {
                EvidenceId id = it.next();
                result.append(id);
                if (!it.hasNext()) continue;
                result.append(",");
            }
            result.append("}");
        }
        result.append("");
        return result.toString();
    }
}

