/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RnaEditingNoteImpl;

public class RnaEditingCommentImpl
extends CommentImpl
implements RnaEditingComment,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private List<Position> positions;
    private RnaEditingNote note;
    private RnaEditingLocationType locationType;

    public RnaEditingCommentImpl() {
        this.setCommentType(CommentType.RNA_EDITING);
        this.positions = new ArrayList<Position>();
        this.note = new RnaEditingNoteImpl();
        this.locationType = RnaEditingLocationType.Undetermined;
    }

    public RnaEditingCommentImpl(RnaEditingComment copy) {
        super(copy);
        this.setCommentType(CommentType.RNA_EDITING);
        this.positions = copy.getPositionsWithEvidences();
        this.note = copy.getRnaEditingNote();
        this.locationType = copy.getLocationType();
    }

    @Override
    public RnaEditingNote getRnaEditingNote() {
        return this.note;
    }

    @Override
    public void setRnaEditingNote(RnaEditingNote note) {
        this.note = note;
    }

    @Override
    public RnaEditingLocationType getLocationType() {
        return this.locationType;
    }

    @Override
    public void setLocationType(RnaEditingLocationType locationType) {
        this.locationType = locationType;
    }

    @Override
    public List<Position> getPositionsWithEvidences() {
        return this.positions;
    }

    @Override
    public void setPositions(List<Position> positionList) {
        this.positions = positionList;
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        this.note.getTexts().stream().flatMap(val -> val.getEvidenceIds().stream()).forEach(val -> evidences.add((EvidenceId)val));
        this.positions.forEach(val -> evidences.addAll(val.getEvidenceIds()));
        return evidences;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.locationType == null ? 0 : this.locationType.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        result = 31 * result + (this.positions == null ? 0 : this.positions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RnaEditingCommentImpl other = (RnaEditingCommentImpl)obj;
        if (this.locationType != other.locationType) {
            return false;
        }
        if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
            return false;
        }
        return !(this.positions == null ? other.positions != null : !this.positions.equals(other.positions));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RnaEditingComment:");
        String molecule = this.getMolecule();
        if (molecule != null && !molecule.isEmpty()) {
            builder.append("[").append(molecule).append("]: ");
        }
        for (Position aPosition : this.positions) {
            builder.append(" ");
            builder.append(aPosition.toString());
        }
        builder.append("; ");
        builder.append(this.note.toString());
        builder.append("; ");
        builder.append("RnaEditingLocationType=").append((Object)this.locationType);
        return builder.toString();
    }
}

