/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.Collection;
import java.util.HashSet;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Disease;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseReferenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class DiseaseCommentStructuredImpl
extends CommentImpl
implements DiseaseCommentStructured {
    private Disease disease = DefaultCommentFactory.getInstance().buildDisease();
    private DiseaseNote note = DefaultCommentFactory.getInstance().buildDiseaseNote();

    public DiseaseCommentStructuredImpl() {
        this.setCommentType(CommentType.DISEASE);
    }

    public DiseaseCommentStructuredImpl(DiseaseCommentStructured copy) {
        super(copy);
        this.setCommentType(CommentType.DISEASE);
        if (copy == null) {
            throw new IllegalArgumentException("Null value provided in the constructor");
        }
        this.disease = DefaultCommentFactory.getInstance().buildDisease(copy.getDisease());
        this.note = DefaultCommentFactory.getInstance().buildDiseaseNote(copy.getNote());
    }

    @Override
    public boolean hasDefinedDisease() {
        return this.disease.getDiseaseId() != null && this.disease.getDiseaseId().getValue() != null && !this.disease.getDiseaseId().getValue().isEmpty() && this.disease.getAcronym() != null && this.disease.getAcronym().getValue() != null && !this.disease.getAcronym().getValue().isEmpty() && this.disease.getDescription() != null && this.disease.getDescription().getValue() != null && !this.disease.getDescription().getValue().isEmpty() && this.disease.getReference() != null && this.disease.getReference().getDiseaseReferenceId() != null && this.disease.getReference().getDiseaseReferenceId().getValue() != null && !this.disease.getReference().getDiseaseReferenceId().getValue().isEmpty() && this.disease.getReference().getDiseaseReferenceType() != null && !this.disease.getReference().getDiseaseReferenceType().equals((Object)DiseaseReferenceType.NONE);
    }

    @Override
    public Disease getDisease() {
        return this.disease;
    }

    @Override
    public void setDisease(Disease disease) {
        this.disease = disease;
    }

    @Override
    public DiseaseNote getNote() {
        return this.note;
    }

    @Override
    public void setNote(DiseaseNote note) {
        this.note = note;
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        this.note.getTexts().stream().flatMap(val -> val.getEvidenceIds().stream()).forEach(val -> evidences.add((EvidenceId)val));
        evidences.addAll(this.disease.getDescription().getEvidenceIds());
        return evidences;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.disease == null ? 0 : this.disease.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiseaseCommentStructuredImpl other = (DiseaseCommentStructuredImpl)obj;
        if (this.disease == null ? other.disease != null : !this.disease.equals(other.disease)) {
            return false;
        }
        return !(this.note == null ? other.note != null : !this.note.equals(other.note));
    }

    public String toString() {
        return "StructuredDiseaseCommentImpl{disease=" + this.disease + ", note=" + this.note + '}';
    }
}

