/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.serialize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultCommonSerializer;
import uk.ac.ebi.kraken.model.serialize.UniParcEntryImplSerializer;

public class DefaultUniParcEntryImplSerializer
extends DefaultCommonSerializer
implements UniParcEntryImplSerializer {
    @Override
    public void writeObject(UniParcEntry entry, ObjectOutput out) throws IOException {
        this.writeId(out, entry);
        this.writeSequence(out, entry.getSequence());
        out.writeUTF(entry.getUniParcId().getValue());
        out.writeInt(entry.getUniProtDatabaseCrossReferences().size());
        for (DatabaseCrossReference xref : entry.getUniProtDatabaseCrossReferences()) {
            this.writeXref(out, xref);
        }
    }

    public void writeXref(ObjectOutput out, DatabaseCrossReference xref) throws IOException {
        out.writeUTF(xref.getAccession());
        out.writeUTF(xref.getChain());
        out.writeLong(xref.getCreated().getTime());
        out.writeUTF(xref.getGiNumber());
        out.writeInt(xref.getInternalVersion());
        out.writeInt(xref.getTaxonomyId());
        out.writeLong(xref.getUpdated().getTime());
        out.writeUTF(xref.getUniProtAccession());
        out.writeInt(xref.getVersion());
        out.writeBoolean(xref.isActive());
        this.writeDatabase(out, xref.getDatabase());
        out.writeUTF(xref.getProteinName());
        out.writeUTF(xref.getGeneName());
        out.writeInt(xref.getExtraTaxonomyIds().size());
        for (int i = 0; i < xref.getExtraTaxonomyIds().size(); ++i) {
            out.writeInt(xref.getExtraTaxonomyIds().get(i));
        }
    }

    private void writeDatabase(ObjectOutput out, Database database) throws IOException {
        out.writeUTF(database.getFullName());
        out.writeUTF(database.getName());
        out.writeInt(database.getVersion());
        out.writeBoolean(database.isAlive());
    }

    @Override
    public void readObject(UniParcEntry entry, ObjectInput in) throws IOException, ClassNotFoundException {
        this.readId(in, entry);
        this.readSequence(in, entry.getSequence());
        entry.getUniParcId().setValue(in.readUTF());
        int xrefSize = in.readInt();
        for (int i = 0; i < xrefSize; ++i) {
            DatabaseCrossReference xref = this.readXref(in);
            entry.getDatabaseCrossReferences().add(xref);
        }
    }

    public DatabaseCrossReference readXref(ObjectInput in) throws IOException {
        DatabaseCrossReference xref = DefaultUniParcFactory.getInstance().buildDatabaseCrossReference();
        xref.setAccession(in.readUTF());
        xref.setChain(in.readUTF());
        xref.setCreated(new Date(in.readLong()));
        xref.setGiNumber(in.readUTF());
        xref.setInternalVersion(in.readInt());
        xref.setTaxonomyId(in.readInt());
        xref.setUpdated(new Date(in.readLong()));
        xref.setUniProtAccession(in.readUTF());
        xref.setVersion(in.readInt());
        xref.setActive(in.readBoolean());
        this.readDatabase(in, xref.getDatabase());
        xref.setProteinName(in.readUTF());
        xref.setGeneName(in.readUTF());
        int size = in.readInt();
        ArrayList<Integer> extTaxIds = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            int taxId = in.readInt();
            extTaxIds.add(taxId);
        }
        xref.setExtraTaxonomyIds(extTaxIds);
        return xref;
    }

    private void readDatabase(ObjectInput in, Database database) throws IOException {
        database.setFullName(in.readUTF());
        database.setName(in.readUTF());
        database.setVersion(in.readInt());
        database.setAlive(in.readBoolean());
    }
}

