/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.serialize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.model.common.PersistentObject;

public class DefaultCommonSerializer {
    protected void readId(ObjectInput in, Object entry) throws IOException, ClassNotFoundException {
        if (entry instanceof PersistentObject) {
            Long id = (Long)in.readObject();
            ((PersistentObject)entry).setId(id);
        } else {
            in.readObject();
        }
    }

    protected void writeId(ObjectOutput out, Object entry) throws IOException {
        if (entry instanceof PersistentObject) {
            long id = ((PersistentObject)entry).getId();
            out.writeObject(id);
        } else {
            out.writeObject(0L);
        }
    }

    protected void writeSequence(ObjectOutput out, Sequence entry) throws IOException {
        out.writeObject(entry.getCRC64());
        out.writeInt(entry.getMolecularWeight());
        out.writeObject(entry.getValue());
    }

    protected void readSequence(ObjectInput in, Sequence entry) throws ClassNotFoundException, IOException {
        String crc64 = (String)in.readObject();
        int molw = in.readInt();
        String seq = (String)in.readObject();
        entry.setCRC64(crc64);
        entry.setMolecularWeight(molw);
        entry.setValue(seq);
    }
}

