/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.description;

public enum FlagType {
    PRECURSOR("Precursor"),
    FRAGMENT("Fragment"),
    FRAGMENTS("Fragments");

    private String value;

    private FlagType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static FlagType typeOf(String value) {
        for (FlagType flagType : FlagType.values()) {
            if (!flagType.getValue().equalsIgnoreCase(value)) continue;
            return flagType;
        }
        throw new IllegalArgumentException(String.format("The Flagtype with value %s does not exist", value));
    }

    public static String[] displayValues() {
        String[] displayValues = new String[FlagType.values().length];
        int count = 0;
        for (FlagType flagType : FlagType.values()) {
            displayValues[count] = flagType.getValue();
            ++count;
        }
        return displayValues;
    }

    public static boolean hasA(String value) {
        for (FlagType flagType : FlagType.values()) {
            if (!flagType.getValue().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

