/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.rlines;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLine;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationSummary;

public class RPLineBuilder
implements RLine<List<CitationSummary>> {
    private static final Pattern RP_BAD_COLON_POSITION_SEPARATION = Pattern.compile(";(\\d+)-");
    private static final String LINE_PREFIX = (Object)((Object)LineType.RP) + "   ";

    @Override
    public List<String> buildLine(List<CitationSummary> f, boolean includeFFMarkup, boolean showEvidence) {
        StringBuilder rpLine = new StringBuilder();
        if (includeFFMarkup) {
            rpLine.append(LINE_PREFIX);
        }
        for (int i = 0; i < f.size(); ++i) {
            String rpValue = f.get(i).getValue();
            rpLine.append(this.correctPositionSemiColonSeparators(rpValue));
            if (i < f.size() - 2) {
                rpLine.append(", ");
                continue;
            }
            if (i < f.size() - 1) {
                rpLine.append(",").append(" AND ");
                continue;
            }
            rpLine.append(".");
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (includeFFMarkup) {
            lines.addAll(FFLineWrapper.buildLines(rpLine.toString(), " ", LINE_PREFIX));
        } else {
            lines.add(rpLine.toString());
        }
        return lines;
    }

    private String correctPositionSemiColonSeparators(String rpValue) {
        Matcher mat = RP_BAD_COLON_POSITION_SEPARATION.matcher(rpValue);
        StringBuilder b = new StringBuilder();
        int start = 0;
        int end = 0;
        int lastEnd = 0;
        while (mat.find()) {
            start = mat.start();
            end = mat.end();
            b.append(rpValue.substring(lastEnd, start)).append("; ").append(mat.group(1)).append("-");
            lastEnd = end;
        }
        b.append(rpValue.substring(lastEnd));
        return b.toString();
    }
}

