/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.cc;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.impl.LineConstant;
import uk.ac.ebi.kraken.ffwriter.line.impl.cc.CCLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;

public class RNAEditingCCLineBuilder
extends CCLineBuilderAbstr<RnaEditingComment> {
    @Override
    protected List<String> buildCommentLines(RnaEditingComment comment, boolean includeFFMarkings, boolean showEvidence) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkings) {
            this.addFlatFileMarkingsIfRequired(includeFFMarkings, sb);
        }
        this.addCommentTypeName(comment, sb);
        this.addMolecule(comment, sb, true);
        int positionCount = 0;
        for (Position aPosition : comment.getPositionsWithEvidences()) {
            if (aPosition.getPosition() != null && aPosition.getPosition().trim().length() >= 0) {
                if (positionCount == 0) {
                    sb.append("Modified_positions=");
                } else {
                    sb.append(", ");
                }
                sb.append(aPosition.getPosition());
            }
            sb = this.addEvidence(aPosition, sb, showEvidence, "");
            ++positionCount;
        }
        if (comment.getPositionsWithEvidences().isEmpty()) {
            sb.append("Modified_positions=");
            sb.append(comment.getLocationType().name());
            sb = this.addEvidence(comment, sb, showEvidence, "");
        }
        sb.append(";");
        if (comment.getRnaEditingNote() != null && !comment.getRnaEditingNote().getTexts().isEmpty()) {
            sb.append(" ");
            sb.append("Note=");
            String freeTextStr = this.buildFreeText(comment.getRnaEditingNote(), showEvidence, ".", ";");
            sb.append(freeTextStr);
        }
        if (includeFFMarkings) {
            return FFLineWrapper.buildLines(sb.toString(), LineConstant.SEPS, this.linePrefix, 80);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(sb.toString());
        return lines;
    }
}

