/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;

public class OGLineBuilder
extends FFLineBuilderAbstr<List<Organelle>>
implements FFLineBuilder<List<Organelle>> {
    private static final String SEPARATOR_AND1 = "and ";

    public OGLineBuilder() {
        super(LineType.OG);
    }

    @Override
    protected FFLine buildLine(List<Organelle> f, boolean showEvidence) {
        ArrayList<String> lls = new ArrayList<String>();
        String[] seps = new String[]{", ", " and "};
        List<String> lls1 = FFLineWrapper.buildLines(this.buildOrganelles(f, showEvidence, true, false).toString(), seps, this.linePrefix, 80);
        List<String> lls2 = FFLineWrapper.buildLines(this.buildOrganelles(f, showEvidence, true, true).toString(), seps, this.linePrefix, 80);
        lls.addAll(lls1);
        lls.addAll(lls2);
        return FFLines.create(lls);
    }

    @Override
    public String buildString(List<Organelle> f) {
        StringBuilder sb = this.buildOrganelles(f, false, false, false);
        StringBuilder plasmid = this.buildOrganelles(f, false, false, true);
        if (plasmid.length() > 0) {
            sb.append(" ").append((CharSequence)plasmid);
        }
        return sb.toString();
    }

    @Override
    public String buildStringWithEvidence(List<Organelle> f) {
        StringBuilder sb = this.buildOrganelles(f, true, false, false);
        StringBuilder plasmid = this.buildOrganelles(f, true, false, true);
        if (plasmid.length() > 0) {
            sb.append(" ").append((CharSequence)plasmid);
        }
        return sb.toString();
    }

    private StringBuilder buildOrganelles(List<Organelle> f, boolean showEvidence, boolean includeFFMarkup, boolean isPlasmid) {
        ArrayList<Organelle> organelles = new ArrayList<Organelle>();
        for (Organelle organelle : f) {
            if (isPlasmid) {
                if (organelle.getType() != GeneEncodingType.PLASMID) continue;
                organelles.add(organelle);
                continue;
            }
            if (organelle.getType() == GeneEncodingType.PLASMID) continue;
            organelles.add(organelle);
        }
        StringBuilder og = new StringBuilder();
        int size = organelles.size();
        if (size == 0) {
            return og;
        }
        if (includeFFMarkup) {
            og.append(this.linePrefix);
        }
        int inc = 0;
        for (Organelle organelle : organelles) {
            if (inc > 0 && inc == size - 1) {
                og.append(SEPARATOR_AND1);
            }
            og.append(this.toSwissprotString(organelle));
            this.addEvidences(og, organelle, showEvidence);
            if (size > 1 && inc != size - 1) {
                og.append(", ");
            }
            ++inc;
        }
        og.append(".");
        return og;
    }

    private String toSwissprotString(Organelle organelle) {
        StringBuilder sb = new StringBuilder();
        switch (organelle.getType()) {
            case HYDROGENOSOME: 
            case MITOCHONDRION: 
            case NUCLEOMORPH: 
            case PLASTID: {
                sb.append(organelle.getType().getValue());
                break;
            }
            case PLASMID: {
                sb.append(organelle.getType().getValue());
                if (organelle.getValue() == null || organelle.getValue().equals("")) break;
                sb.append(" ");
                sb.append(organelle.getValue());
                break;
            }
            case APICOPLAST_PLASTID: 
            case CHLOROPLAST_PLASTID: 
            case CYANELLE_PLASTID: 
            case NON_PHOTOSYNTHETIC_PLASTID: 
            case CHROMATOPHORE_PLASTID: {
                sb.append("Plastid; ");
                sb.append(organelle.getType().getValue());
                break;
            }
        }
        return sb.toString();
    }
}

