/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl;

import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;
import uk.ac.ebi.kraken.ffwriter.line.FFLineBuilder;
import uk.ac.ebi.kraken.ffwriter.line.FFLineWrapper;
import uk.ac.ebi.kraken.ffwriter.line.FFLines;
import uk.ac.ebi.kraken.ffwriter.line.impl.FFLineBuilderAbstr;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;

public class OCLineBuilder
extends FFLineBuilderAbstr<List<NcbiTaxon>>
implements FFLineBuilder<List<NcbiTaxon>> {
    private static final String UNCLASSIFIED = "unclassified";

    public OCLineBuilder() {
        super(LineType.OC);
    }

    @Override
    protected FFLine buildLine(List<NcbiTaxon> f, boolean showEvidence) {
        StringBuilder sb = this.build(f, true);
        List<String> lls = FFLineWrapper.buildLines(sb, "; ", this.linePrefix);
        return FFLines.create(lls);
    }

    @Override
    public String buildString(List<NcbiTaxon> f) {
        return this.build(f, false).toString();
    }

    @Override
    public String buildStringWithEvidence(List<NcbiTaxon> f) {
        return this.build(f, false).toString();
    }

    private StringBuilder build(List<NcbiTaxon> f, boolean includeFFMarkup) {
        StringBuilder sb = new StringBuilder();
        if (includeFFMarkup) {
            sb.append(this.linePrefix);
        }
        if (!f.isEmpty()) {
            boolean isFirst = true;
            for (NcbiTaxon taxon : f) {
                if (!isFirst) {
                    sb.append("; ");
                }
                sb.append(taxon.getValue());
                isFirst = false;
            }
        } else {
            sb.append(UNCLASSIFIED);
        }
        sb.append(".");
        return sb;
    }
}

