/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.line.FFLine;

public class FFLines {
    public static FFLine create(List<String> lls) {
        return new FFLineImpl(lls);
    }

    public static FFLine create() {
        return new FFLineImpl(new ArrayList<String>());
    }

    static class FFLineImpl
    implements FFLine {
        public List<String> lls;

        FFLineImpl(List<String> lls) {
            this.lls = lls;
        }

        @Override
        public List<String> lines() {
            if (this.lls == null) {
                this.lls = new ArrayList<String>();
            }
            return this.lls;
        }

        public String toString() {
            if (this.lls == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (String ll : this.lls) {
                if (!isFirst) {
                    sb.append('\n');
                }
                sb.append(ll);
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public void add(FFLine line) {
            if (this.lls == null) {
                this.lls = new ArrayList<String>();
            }
            this.lls.addAll(line.lines());
        }

        @Override
        public boolean isEmpty() {
            return this.lls.isEmpty();
        }

        @Override
        public void add(String line) {
            if (line == null || line.isEmpty()) {
                return;
            }
            if (this.lls == null) {
                this.lls = new ArrayList<String>();
            }
            this.lls.add(line);
        }
    }
}

