/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FFLineWrapper {
    private static final String[] NOT_WRAPPED = new String[]{"->", "-->", "- ", "EC ", "TC ", "ECO:"};
    private static final String DASH = "-";

    public static StringBuilder wrap(StringBuilder wrapThis, String[] separators, String linePrefix, int lineLength) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String line : FFLineWrapper.buildLines(wrapThis.toString(), separators, linePrefix, lineLength)) {
            if (!isFirst) {
                sb.append('\n');
            }
            sb.append(line);
            isFirst = false;
        }
        return sb;
    }

    public static List<String> buildLines(StringBuilder wrapThis, String separator, String linePrefix) {
        return FFLineWrapper.buildLines(wrapThis.toString(), separator, linePrefix);
    }

    public static List<String> buildLines(String wrapThis, String separator, String linePrefix) {
        return FFLineWrapper.buildLines(wrapThis, separator, linePrefix, 80);
    }

    public static List<String> buildLines(String wrapThis, String separator, String linePrefix, int lineLength) {
        if (separator.isEmpty()) {
            return FFLineWrapper.buildLinesNoSeparator(wrapThis, linePrefix, lineLength);
        }
        String[] seps = new String[]{separator};
        return FFLineWrapper.buildLines(wrapThis, seps, linePrefix, lineLength);
    }

    public static List<String> buildLinesNoSeparator(String wrapThis, String linePrefix, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        if (wrapThis.isEmpty()) {
            return lines;
        }
        String tempStr = wrapThis;
        while (tempStr.length() > lineLength) {
            String line = tempStr.substring(0, lineLength);
            lines.add(line);
            tempStr = linePrefix + tempStr.substring(lineLength);
            if (tempStr.length() > lineLength) continue;
            break;
        }
        if (tempStr.length() <= lineLength) {
            lines.add(tempStr);
        }
        return lines;
    }

    public static List<String> buildLines(String wrapThis, String[] separators, String linePrefix, int lineLength, List<String> words) {
        ArrayList<String> lines = new ArrayList<String>();
        if (wrapThis.isEmpty()) {
            return lines;
        }
        String tempStr = wrapThis;
        int startPoint = linePrefix.length();
        if (tempStr.length() <= lineLength) {
            lines.add(tempStr);
            return lines;
        }
        while (tempStr.length() > lineLength) {
            Map.Entry<Integer, String> indexSep = FFLineWrapper.getIndex(tempStr, separators, lineLength, startPoint, true, words);
            int index = indexSep.getKey();
            if (index <= startPoint) {
                indexSep = FFLineWrapper.getIndex(tempStr, separators, lineLength, startPoint, false, words);
            }
            index = indexSep.getKey();
            String separator = indexSep.getValue();
            if (index <= startPoint) {
                lines.add(tempStr);
                break;
            }
            String line = tempStr.substring(0, index + separator.length()).trim();
            lines.add(line);
            tempStr = linePrefix + tempStr.substring(index + separator.length());
            if (tempStr.length() > lineLength) continue;
            lines.add(tempStr);
            break;
        }
        return lines;
    }

    public static List<String> buildLines(String wrapThis, String[] separators, String linePrefix, int lineLength) {
        return FFLineWrapper.buildLines(wrapThis, separators, linePrefix, lineLength, Collections.emptyList());
    }

    public static List<String> buildLine(List<String> tokens, String separator, String space, String stop, String linePrefix, boolean wrapping) {
        ArrayList<String> lines = new ArrayList<String>();
        if (tokens.isEmpty()) {
            return lines;
        }
        int count = 0;
        StringBuilder line = new StringBuilder();
        line.append(linePrefix);
        for (String token : tokens) {
            ++count;
            if (wrapping && line.length() + token.length() + separator.length() >= 80) {
                lines.add(line.toString());
                line = new StringBuilder(linePrefix);
            } else if (count != 1) {
                line.append(space);
            }
            line.append(token);
            if (count < tokens.size()) {
                line.append(separator);
                continue;
            }
            line.append(stop);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    private static Map.Entry<Integer, String> getIndex(String str, String[] separators, int lineLength, int startPoint, boolean fromLast) {
        int index = 0;
        String sep = "";
        Map<String, List<Integer>> notWrappedMap = FFLineWrapper.getNotWrappedMap(str, startPoint);
        for (String separator : separators) {
            int index2;
            int sepLength = ("a" + separator).trim().length() - 1;
            if (fromLast) {
                index2 = FFLineWrapper.getWrappingPoint(str, separator, lineLength - sepLength, startPoint, true, notWrappedMap, Collections.emptyList());
                if (index2 <= index) continue;
                index = index2;
                sep = separator;
                continue;
            }
            index2 = FFLineWrapper.getWrappingPoint(str, separator, lineLength - sepLength, startPoint, false, notWrappedMap, Collections.emptyList());
            if (index != 0 && index2 >= index) continue;
            index = index2;
            sep = separator;
        }
        return new AbstractMap.SimpleEntry<Integer, String>(index, sep);
    }

    private static Map.Entry<Integer, String> getIndex(String str, String[] separators, int lineLength, int startPoint, boolean fromLast, List<String> reservedWords) {
        int index = 0;
        String sep = "";
        Map<String, List<Integer>> notWrappedMap = FFLineWrapper.getNotWrappedMap(str, startPoint);
        for (String separator : separators) {
            int index2;
            int sepLength = ("a" + separator).trim().length() - 1;
            if (fromLast) {
                index2 = FFLineWrapper.getWrappingPoint(str, separator, lineLength - sepLength, startPoint, true, notWrappedMap, reservedWords);
                if (index2 <= index) continue;
                index = index2;
                sep = separator;
                continue;
            }
            index2 = FFLineWrapper.getWrappingPoint(str, separator, lineLength - sepLength, startPoint, false, notWrappedMap, reservedWords);
            if (index != 0 && index2 >= index) continue;
            index = index2;
            sep = separator;
        }
        return new AbstractMap.SimpleEntry<Integer, String>(index, sep);
    }

    private static int getWrappingPoint(String str, String sep, int lineLength, int startPoint, boolean last, Map<String, List<Integer>> notWrapped, List<String> reservedWords) {
        boolean isSpace = sep.equals(" ");
        if (last) {
            int end = lineLength;
            int index2 = str.lastIndexOf(sep, end);
            if (index2 == -1) {
                return index2;
            }
            while (FFLineWrapper.isContain(index2, notWrapped, isSpace) || FFLineWrapper.isInReservedWords(str, index2, reservedWords)) {
                end = index2;
                index2 = str.lastIndexOf(sep, end -= sep.length());
                if (index2 != -1) continue;
                return index2;
            }
            return index2;
        }
        int start = startPoint;
        int index2 = str.indexOf(sep, start);
        if (index2 == -1) {
            return index2;
        }
        while (FFLineWrapper.isContain(index2, notWrapped, isSpace) || FFLineWrapper.isInReservedWords(str, index2, reservedWords)) {
            start = index2;
            index2 = str.indexOf(sep, start += sep.length());
            if (index2 != -1) continue;
            return index2;
        }
        return index2;
    }

    private static boolean isInReservedWords(String val, int index, List<String> reservedWords) {
        for (String word : reservedWords) {
            int indexStr = val.indexOf(word);
            if (index < indexStr || index >= indexStr + word.length()) continue;
            return true;
        }
        return false;
    }

    private static boolean isContain(int val, Map<String, List<Integer>> notWrapped, boolean isSpace) {
        if (notWrapped.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, List<Integer>> entry : notWrapped.entrySet()) {
            int len = entry.getKey().length();
            for (int index : entry.getValue()) {
                if (val == index) {
                    return true;
                }
                if (val > index && val < index + len && !isSpace) {
                    return true;
                }
                if (val != index + len - 1 || !isSpace) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, List<Integer>> getNotWrappedMap(String val, int start) {
        TreeMap<String, List<Integer>> notWrapped = new TreeMap<String, List<Integer>>();
        int start1 = start;
        for (String s : NOT_WRAPPED) {
            int index = 0;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            while ((index = val.indexOf(s, start1)) != -1) {
                indices.add(index);
                start1 = index;
                start1 += s.length();
                if (index != -1) continue;
            }
            if (indices.isEmpty()) continue;
            notWrapped.put(s, indices);
        }
        FFLineWrapper.addDashSpecial(notWrapped, val, start);
        return notWrapped;
    }

    private static void addDashSpecial(Map<String, List<Integer>> notWrapped, String val, int start) {
        int start1 = start;
        int length = val.length();
        int index = 0;
        while ((index = val.indexOf(DASH, start1)) != -1 && index != length - 1) {
            String found = FFLineWrapper.isInNotWrapped(notWrapped, index);
            if (found != null) {
                start1 += found.length();
            } else if (FFLineWrapper.isSpecialCharacter(val.charAt(index + 1))) {
                String dashSp = DASH + val.charAt(index + 1);
                start1 += 2;
                notWrapped.computeIfAbsent(dashSp, k -> new ArrayList()).add(index);
            } else {
                start1 += 2;
            }
            if (index != -1) continue;
        }
    }

    private static String isInNotWrapped(Map<String, List<Integer>> notWrapped, int index) {
        for (Map.Entry<String, List<Integer>> entry : notWrapped.entrySet()) {
            if (!entry.getValue().stream().anyMatch(val -> val == index)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean isSpecialCharacter(char c) {
        boolean isChar = Character.isDigit(c) || Character.isLetter(c) || c == '(' || c == '[';
        return !isChar;
    }
}

