/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.table;

import java.awt.Component;
import java.io.File;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.LinkedList;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ColumnSummaryTableCellRenderer
implements TableCellRenderer,
TableModelListener {
    private TableCellRenderer defaultRenderer;
    private List<Integer> summaryColumns;
    private Map<Integer, String> columnSummary = new HashMap<Integer, String>();
    private static final Collector<CharSequence, ?, String> JOIN_LIST = Collectors.joining("</li><li>", "<ul><li>", "</li></ul>");

    public ColumnSummaryTableCellRenderer(TableCellRenderer defaultRenderer, TableModel model) {
        this(defaultRenderer);
        model.addTableModelListener(this);
    }

    public ColumnSummaryTableCellRenderer(TableCellRenderer defaultRenderer) {
        this(defaultRenderer, Collections.emptyList());
    }

    public ColumnSummaryTableCellRenderer(TableCellRenderer defaultRenderer, List<Integer> summaryColumns, TableModel model) {
        this(defaultRenderer, summaryColumns);
        model.addTableModelListener(this);
    }

    public ColumnSummaryTableCellRenderer(TableCellRenderer defaultRenderer, List<Integer> summaryColumns) {
        this.defaultRenderer = defaultRenderer;
        this.summaryColumns = summaryColumns;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int columnModel = table.convertColumnIndexToModel(column);
        if (component instanceof JComponent) {
            String tooltip = this.getTooltip(table, columnModel);
            ((JComponent)component).setToolTipText(tooltip.isEmpty() ? null : tooltip);
        }
        return component;
    }

    protected String getTooltip(JTable table, int columnModel) {
        String toolTip = "";
        if (this.summaryColumns.isEmpty() || this.summaryColumns.contains(columnModel)) {
            if (!this.columnSummary.containsKey(columnModel)) {
                this.columnSummary.put(columnModel, this.getColumnSummary(table.getModel(), columnModel));
            }
            toolTip = this.columnSummary.get(columnModel);
        }
        return toolTip;
    }

    protected String getColumnSummary(TableModel model, int columnModel) {
        Class<Object> columnClass = model.getColumnClass(columnModel);
        if (columnClass.isAssignableFrom(String.class)) {
            return this.getStringColumnSummary(model, columnModel);
        }
        if (columnClass.isAssignableFrom(Double.class)) {
            return this.getDoubleColumnSummary(model, columnModel);
        }
        if (columnClass.isAssignableFrom(Float.class)) {
            return this.getFloatColumnSummary(model, columnModel);
        }
        if (columnClass.isAssignableFrom(Integer.class)) {
            return this.getIntegerColumnSummary(model, columnModel);
        }
        if (columnClass.isAssignableFrom(Long.class)) {
            return this.getLongColumnSummary(model, columnModel);
        }
        if (columnClass.isAssignableFrom(File.class)) {
            return this.getFileColumnSummary(model, columnModel);
        }
        return "";
    }

    protected String getStringColumnSummary(TableModel model, int columnModel) {
        HashSet<String> values = new HashSet<String>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            values.add((String)model.getValueAt(row, columnModel));
        }
        return this.getStringValuesSummary(values, "String");
    }

    protected String getStringValuesSummary(Set<String> values, String stringType) {
        StringBuilder summary = new StringBuilder();
        summary.append("<html>").append("Type: ").append(stringType).append("<br/").append("Values:").append(values.stream().collect(JOIN_LIST)).append("</html>");
        return summary.toString();
    }

    protected String getFileColumnSummary(TableModel model, int columnModel) {
        HashSet<String> values = new HashSet<String>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            values.add(this.fileToString((File)model.getValueAt(row, columnModel)));
        }
        return this.getStringValuesSummary(values, "File");
    }

    protected String fileToString(File file) {
        return file.getName();
    }

    private String getDoubleColumnSummary(TableModel model, int columnModel) {
        LinkedList<Double> values = new LinkedList<Double>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            values.add((Double)model.getValueAt(row, columnModel));
        }
        return this.getDoubleListSummary(values, "double");
    }

    protected String getFloatColumnSummary(TableModel model, int columnModel) {
        LinkedList<Double> values = new LinkedList<Double>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            values.add(((Float)model.getValueAt(row, columnModel)).doubleValue());
        }
        return this.getDoubleListSummary(values, "float");
    }

    protected String getDoubleListSummary(List<Double> values, String numericType) {
        DoubleSummaryStatistics statistics = values.stream().collect(Collectors.summarizingDouble(Double::doubleValue));
        return this.getSummary(numericType, new SummaryStatistics(statistics));
    }

    protected String getIntegerColumnSummary(TableModel model, int columnModel) {
        LinkedList<Integer> values = new LinkedList<Integer>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            values.add((Integer)model.getValueAt(row, columnModel));
        }
        IntSummaryStatistics statistics = values.stream().collect(Collectors.summarizingInt(Integer::intValue));
        return this.getSummary("integer", new SummaryStatistics(statistics));
    }

    protected String getLongColumnSummary(TableModel model, int columnModel) {
        LinkedList<Long> values = new LinkedList<Long>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            values.add((Long)model.getValueAt(row, columnModel));
        }
        LongSummaryStatistics statistics = values.stream().collect(Collectors.summarizingLong(Long::longValue));
        return this.getSummary("integer", new SummaryStatistics(statistics));
    }

    private String getSummary(String numericType, SummaryStatistics statistics) {
        StringBuilder summary = new StringBuilder();
        summary.append("<html>").append("Type: Numeric (").append(numericType).append(")<br/").append("Summary:").append(statistics.toHtmlList()).append("</html>");
        return summary.toString();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.columnSummary.clear();
    }

    private class SummaryStatistics {
        private double average;
        private double max;
        private double min;
        private long count;
        private double sum;

        public SummaryStatistics(DoubleSummaryStatistics statistics) {
            this(statistics.getAverage(), statistics.getMax(), statistics.getMin(), statistics.getCount(), statistics.getSum());
        }

        public SummaryStatistics(IntSummaryStatistics statistics) {
            this(statistics.getAverage(), statistics.getMax(), statistics.getMin(), statistics.getCount(), statistics.getSum());
        }

        public SummaryStatistics(LongSummaryStatistics statistics) {
            this(statistics.getAverage(), statistics.getMax(), statistics.getMin(), statistics.getCount(), statistics.getSum());
        }

        public SummaryStatistics(double average, double max, double min, long count, double sum) {
            this.average = average;
            this.max = max;
            this.min = min;
            this.count = count;
            this.sum = sum;
        }

        public String toHtmlList() {
            StringJoiner joiner = new StringJoiner("</li><li>", "<ul><li>", "</li></ul>");
            joiner.add("Average: " + this.getAverage()).add("Maximum: " + this.getMax()).add("Minimum: " + this.getMin()).add("Count: " + this.getCount()).add("Sum: " + this.getSum());
            return joiner.toString();
        }

        public double getAverage() {
            return this.average;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        public long getCount() {
            return this.count;
        }

        public double getSum() {
            return this.sum;
        }
    }
}

