/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.sing_group.gc4s.ui.icons.Icons;

public abstract class ComponentsListPanel<T extends Component>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int initialComponents;
    private JPanel componentsPanel;
    private List<ComponentWrapPanel> wrapedComponents = new ArrayList<ComponentWrapPanel>();

    public ComponentsListPanel(int initialComponents) {
        this.initialComponents = initialComponents;
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNorthComponent(), "North");
        this.add(this.getCenterComponent(), "Center");
    }

    protected JPanel getNorthComponent() {
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.add(Box.createHorizontalGlue());
        northPanel.add(this.getAddComponentButton());
        northPanel.add(Box.createHorizontalStrut(5));
        northPanel.add(this.getRemoveAllComponentsButton());
        northPanel.add(Box.createHorizontalGlue());
        return northPanel;
    }

    protected JButton getAddComponentButton() {
        JButton addComponentButton = new JButton(this.getAddComponentButtonLabel(), Icons.ICON_ADD_16);
        addComponentButton.addActionListener(event -> this.addComponentWrapPanelComponent());
        return addComponentButton;
    }

    protected String getAddComponentButtonLabel() {
        return "Add component";
    }

    protected JButton getRemoveAllComponentsButton() {
        JButton removeAllComponentsButton = new JButton(this.getRemoveAllComponentsButtonLabel(), Icons.ICON_TRASH_16);
        removeAllComponentsButton.addActionListener(event -> this.removeAllComponents());
        return removeAllComponentsButton;
    }

    protected String getRemoveAllComponentsButtonLabel() {
        return "Remove all";
    }

    protected Component getCenterComponent() {
        JPanel centerPanel = new JPanel();
        this.componentsPanel = new JPanel();
        this.componentsPanel.setLayout(new BoxLayout(this.componentsPanel, 1));
        centerPanel.add(this.componentsPanel);
        for (int i = 0; i < this.initialComponents; ++i) {
            this.addComponentWrapPanelComponent();
        }
        return new JScrollPane(centerPanel);
    }

    protected abstract T getGenericComponent();

    public List<T> getComponentsList() {
        return this.wrapedComponents.stream().map(ComponentWrapPanel::getWrappedComponent).collect(Collectors.toList());
    }

    protected void addComponentWrapPanelComponent() {
        this.addComponentWrapPanelComponent(new ComponentWrapPanel());
    }

    protected void addComponentWrapPanelComponent(Supplier<T> supplier) {
        this.addComponentWrapPanelComponent(new ComponentWrapPanel(supplier));
    }

    protected void addComponentWrapPanelComponent(ComponentWrapPanel component) {
        this.wrapedComponents.add(component);
        this.componentsPanel.add(component);
        this.updateUI();
    }

    protected void removeComponentWrapPanel(ComponentWrapPanel component) {
        this.wrapedComponents.remove(component);
        this.componentsPanel.remove(component);
        this.updateUI();
    }

    public void removeAllComponents() {
        this.wrapedComponents.clear();
        this.componentsPanel.removeAll();
        this.updateUI();
    }

    protected class ComponentWrapPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private T wrappedComponent;

        ComponentWrapPanel() {
            this(this$0::getGenericComponent);
        }

        ComponentWrapPanel(Supplier<T> wrappedComponentProvider) {
            this.init(wrappedComponentProvider);
        }

        private void init(Supplier<T> wrappedComponentProvider) {
            this.setLayout(new FlowLayout());
            this.wrappedComponent = (Component)wrappedComponentProvider.get();
            this.add((Component)this.wrappedComponent);
            this.add(this.getRemoveButton());
        }

        private JButton getRemoveButton() {
            JButton removeButton = new JButton(Icons.ICON_CANCEL_16);
            removeButton.addActionListener(event -> ComponentsListPanel.this.removeComponentWrapPanel(this));
            return removeButton;
        }

        public T getWrappedComponent() {
            return this.wrappedComponent;
        }
    }
}

