/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.bedtools.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.JPanel;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.DefaultBedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.DockerBedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.bedtools.gui.SystemBinaryExecutionConfigurationPanel;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;

public class BedToolsExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    private CardsPanel bedToolsExecutableCardsPanel;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;
    private BinaryConfigurationPanelListener<BedToolsBinariesExecutor> bedToolsExecutorChanged;

    public BedToolsExecutionConfigurationPanel(BinaryConfigurationPanelListener<BedToolsBinariesExecutor> binaryConfigurationPanelListener) {
        this.bedToolsExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.bedToolsExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.bedToolsExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty("seda.local.execution.enabled.bedtools", "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.bedToolsExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.bedToolsExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::bedToolsBinaryExecutorCardChanged);
        this.add((Component)this.bedToolsExecutableCardsPanel);
    }

    private void bedToolsBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.bedToolsExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<BedToolsBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<BedToolsBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.bedToolsExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(BedToolsBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerBedToolsBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSelectedDockerImage(((DockerBedToolsBinariesExecutor)binariesExecutor).getDockerImage());
            this.bedToolsExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultBedToolsBinariesExecutor) {
            File directory = ((DefaultBedToolsBinariesExecutor)binariesExecutor).getBedToolsBinary();
            if (directory != null) {
                this.systemBinaryExecutionConfigurationPanel.setSelectedFile(directory);
            } else {
                this.systemBinaryExecutionConfigurationPanel.clearSelectedFile();
            }
            this.bedToolsExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown BedToolsBinariesExecutor implementation");
        }
    }
}

